#  - HL7 Terminology (THO) v7.0.0

## : 



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "hxutg1-1-0-9",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-pclocd-ns-1-0-19",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-pclocd-ns-1-0-19",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-pclocd-ns-1-0-19\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-pclocd-ns-1-0-19</b></p><a name=\"hx1i-pclocd-ns-1-0-19\"> </a><a name=\"hchx1i-pclocd-ns-1-0-19\"> </a><p>Provenance for <a href=\"NamingSystem-pclocd.html\">NamingSystem pan-Canadian LOINC Observation Code Database</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-13</td></tr><tr><td>Recorded</td><td>2020-07-13 13:23:32+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joel Francis</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/pclocd"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-13"
        },
        "recorded" : "2020-07-13T13:23:32+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Change the pCLOCD external Code System and Naming System entries to be aligned with what the HTA and the terminology owners wish it to be."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joel Francis"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-nanda-i-ns-1-0-20",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-nanda-i-ns-1-0-20",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-nanda-i-ns-1-0-20\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-nanda-i-ns-1-0-20</b></p><a name=\"hx1i-nanda-i-ns-1-0-20\"> </a><a name=\"hchx1i-nanda-i-ns-1-0-20\"> </a><p>Provenance for <a href=\"NamingSystem-nanda-i.html\">NamingSystem NANDA International</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-15</td></tr><tr><td>Recorded</td><td>2020-07-15 14:10:15+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/nanda-i"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-15"
        },
        "recorded" : "2020-07-15T14:10:15+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "One of the code system stubs with its associated NamingSystem entry brought in from V3 needs to be corrected and brought into alignment with HTA documented information on the code system."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-ActInjuryCodeCSA-vs-1-0-21",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-ActInjuryCodeCSA-vs-1-0-21",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-ActInjuryCodeCSA-vs-1-0-21\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-ActInjuryCodeCSA-vs-1-0-21</b></p><a name=\"hx1i-v3-ActInjuryCodeCSA-vs-1-0-21\"> </a><a name=\"hchx1i-v3-ActInjuryCodeCSA-vs-1-0-21\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActInjuryCodeCSA.html\">ValueSet ActInjuryCodeCSA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-16</td></tr><tr><td>Recorded</td><td>2020-07-16 15:02:04+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActInjuryCodeCSA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-16"
        },
        "recorded" : "2020-07-16T15:02:04+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Imported to support coreemif generation function."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-ActProcedureCodeCCI-vs-1-0-21",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-ActProcedureCodeCCI-vs-1-0-21",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-ActProcedureCodeCCI-vs-1-0-21\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-ActProcedureCodeCCI-vs-1-0-21</b></p><a name=\"hx1i-v3-ActProcedureCodeCCI-vs-1-0-21\"> </a><a name=\"hchx1i-v3-ActProcedureCodeCCI-vs-1-0-21\"> </a><p>Provenance for <a href=\"ValueSet-v3-ActProcedureCodeCCI.html\">ValueSet Act Procedure Code CCI</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-16</td></tr><tr><td>Recorded</td><td>2020-07-16 15:02:54+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-ActProcedureCodeCCI"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-16"
        },
        "recorded" : "2020-07-16T15:02:54+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Imported to support coreemif generation function."
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-DataOperation-cs-1-1-22",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-DataOperation-cs-1-1-22",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-DataOperation-cs-1-1-22\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-DataOperation-cs-1-1-22</b></p><a name=\"hx1i-v3-DataOperation-cs-1-1-22\"> </a><a name=\"hchx1i-v3-DataOperation-cs-1-1-22\"> </a><p>Provenance for <a href=\"CodeSystem-v3-DataOperation.html\">CodeSystem DataOperation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-29</td></tr><tr><td>Recorded</td><td>2020-07-29 13:14:54+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-DataOperation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-29"
        },
        "recorded" : "2020-07-29T13:14:54+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add DEPRECATE to support UTG maintenance operations"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-CodeSystem-cs-1-1-22",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-CodeSystem-cs-1-1-22",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-CodeSystem-cs-1-1-22\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-CodeSystem-cs-1-1-22</b></p><a name=\"hx1i-v3-CodeSystem-cs-1-1-22\"> </a><a name=\"hchx1i-v3-CodeSystem-cs-1-1-22\"> </a><p>Provenance for <a href=\"CodeSystem-v3-CodeSystem.html\">CodeSystem CodeSystem</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-29</td></tr><tr><td>Recorded</td><td>2020-07-29 13:18:09+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-CodeSystem"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-29"
        },
        "recorded" : "2020-07-29T13:18:09+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Technical correction for import error, status retired"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-HealthcareProviderTaxonomyHIPAA-cs-1-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-HealthcareProviderTaxonomyHIPAA-cs-1-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-HealthcareProviderTaxonomyHIPAA-cs-1-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-HealthcareProviderTaxonomyHIPAA-cs-1-1-24</b></p><a name=\"hx1i-v3-HealthcareProviderTaxonomyHIPAA-cs-1-1-24\"> </a><a name=\"hchx1i-v3-HealthcareProviderTaxonomyHIPAA-cs-1-1-24\"> </a><p>Provenance for <a href=\"CodeSystem-v3-HealthcareProviderTaxonomyHIPAA.html\">CodeSystem Healthcare Provider Taxonomy HIPAA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-29</td></tr><tr><td>Recorded</td><td>2020-07-29 17:41:05+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-HealthcareProviderTaxonomyHIPAA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-29"
        },
        "recorded" : "2020-07-29T17:41:05+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Technical correction for import error, status retired"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-nuccProviderCodes-ns-1-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-nuccProviderCodes-ns-1-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-nuccProviderCodes-ns-1-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-nuccProviderCodes-ns-1-1-24</b></p><a name=\"hx1i-v3-nuccProviderCodes-ns-1-1-24\"> </a><a name=\"hchx1i-v3-nuccProviderCodes-ns-1-1-24\"> </a><p>Provenance for <a href=\"NamingSystem-v3-nuccProviderCodes.html\">NamingSystem NUCC Health Care Provider Taxonomy</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-29</td></tr><tr><td>Recorded</td><td>2020-07-29 17:42:13+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-nuccProviderCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-29"
        },
        "recorded" : "2020-07-29T17:42:13+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Technical correction for import error, docuent bad URL"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-HealthcareProviderTaxonomyHIPAA-ns-1-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-HealthcareProviderTaxonomyHIPAA-ns-1-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-HealthcareProviderTaxonomyHIPAA-ns-1-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-HealthcareProviderTaxonomyHIPAA-ns-1-1-24</b></p><a name=\"hx1i-v3-HealthcareProviderTaxonomyHIPAA-ns-1-1-24\"> </a><a name=\"hchx1i-v3-HealthcareProviderTaxonomyHIPAA-ns-1-1-24\"> </a><p>Provenance for <a href=\"NamingSystem-v3-HealthcareProviderTaxonomyHIPAA.html\">NamingSystem Healthcare Provider Taxonomy HIPAA</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-29</td></tr><tr><td>Recorded</td><td>2020-07-29 18:33:42+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-HealthcareProviderTaxonomyHIPAA"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-29"
        },
        "recorded" : "2020-07-29T18:33:42+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Technical correction for import error, status retired"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-conceptdomains-cs-1-1-25",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-conceptdomains-cs-1-1-25",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-conceptdomains-cs-1-1-25\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-conceptdomains-cs-1-1-25</b></p><a name=\"hx1i-conceptdomains-cs-1-1-25\"> </a><a name=\"hchx1i-conceptdomains-cs-1-1-25\"> </a><p>Provenance for <a href=\"CodeSystem-conceptdomains.html\">CodeSystem Concept Domains</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-31</td></tr><tr><td>Recorded</td><td>2020-07-31 10:54:46+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/conceptdomains"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-31"
        },
        "recorded" : "2020-07-31T10:54:46+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Technical correction: the Deprecation information in the last V3 Coremif from harmonization was not imported; the missing information for the deprecated Concept Domains. The Deprecated Domains are: ObservationPopulationInclusionType, TransmissionRelationshipTypeCode, and TriggerEventID"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-utg-concept-properties-cs-1-1-25",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-utg-concept-properties-cs-1-1-25",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-utg-concept-properties-cs-1-1-25\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-utg-concept-properties-cs-1-1-25</b></p><a name=\"hx1i-utg-concept-properties-cs-1-1-25\"> </a><a name=\"hchx1i-utg-concept-properties-cs-1-1-25\"> </a><p>Provenance for <a href=\"CodeSystem-utg-concept-properties.html\">CodeSystem UTG Specific Concept Properties</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-07-31</td></tr><tr><td>Recorded</td><td>2020-07-31 10:59:58+1000</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/utg-concept-properties"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-07-31"
        },
        "recorded" : "2020-07-31T10:59:58+10:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Technical correction: UP-85 add property to support coremif required deprecation informaton on concepts"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-34",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-34",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-34\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-34</b></p><a name=\"hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-34\"> </a><a name=\"hchx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-34\"> </a><p>Provenance for <a href=\"ValueSet-v3-KnowledgeSubjectObservationValue.html\">ValueSet KnowledgeSubjectObservationValue</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-08-28</td></tr><tr><td>Recorded</td><td>2020-08-28 13:46:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-KnowledgeSubjectObservationValue"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-08-28"
        },
        "recorded" : "2020-08-28T13:46:25-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix erroneous compose uri for MSH"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-iso3166-1-ns-1-1-35",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-iso3166-1-ns-1-1-35",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-iso3166-1-ns-1-1-35\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-iso3166-1-ns-1-1-35</b></p><a name=\"hx1i-v3-iso3166-1-ns-1-1-35\"> </a><a name=\"hchx1i-v3-iso3166-1-ns-1-1-35\"> </a><p>Provenance for <a href=\"NamingSystem-v3-iso3166-1.html\">NamingSystem ISO 3166 Part 1 Country Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-08-28</td></tr><tr><td>Recorded</td><td>2020-08-28 16:15:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-iso3166-1"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-08-28"
        },
        "recorded" : "2020-08-28T16:15:22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add correct uri entry"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-36",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-36",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-36\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-36</b></p><a name=\"hx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-36\"> </a><a name=\"hchx1i-v3-KnowledgeSubjectObservationValue-vs-1-1-36\"> </a><p>Provenance for <a href=\"ValueSet-v3-KnowledgeSubjectObservationValue.html\">ValueSet KnowledgeSubjectObservationValue</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-08-29</td></tr><tr><td>Recorded</td><td>2020-08-29 10:39:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/v3-KnowledgeSubjectObservationValue"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-08-29"
        },
        "recorded" : "2020-08-29T10:39:22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix erroneous compose uri for ICD"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-operation-outcome-cs-1-1-62",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-operation-outcome-cs-1-1-62",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-operation-outcome-cs-1-1-62\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-operation-outcome-cs-1-1-62</b></p><a name=\"hx1i-operation-outcome-cs-1-1-62\"> </a><a name=\"hchx1i-operation-outcome-cs-1-1-62\"> </a><p>Provenance for <a href=\"CodeSystem-operation-outcome.html\">CodeSystem Operation Outcome Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2020-10-29</td></tr><tr><td>Recorded</td><td>2020-10-29 13:19:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Ted Klein</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Vocabulary WG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/operation-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2020-10-29"
        },
        "recorded" : "2020-10-29T13:19:22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Fix bad designation-use code value"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Ted Klein"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Vocabulary WG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-ParticipationMode-cs-2-1-25",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-ParticipationMode-cs-2-1-25",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-ParticipationMode-cs-2-1-25\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-ParticipationMode-cs-2-1-25</b></p><a name=\"hx1i-v3-ParticipationMode-cs-2-1-25\"> </a><a name=\"hchx1i-v3-ParticipationMode-cs-2-1-25\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ParticipationMode.html\">CodeSystem ParticipationMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-09-02</td></tr><tr><td>Recorded</td><td>2021-09-02 17:13:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Joan Harper</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>Canada Health Infoway</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ParticipationMode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-09-02"
        },
        "recorded" : "2021-09-02T17:13:37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add text messaging values to the ParticipationMode code system; UP-226"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Joan Harper"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "Canada Health Infoway"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-presentOnAdmission-cs-2-1-29",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-presentOnAdmission-cs-2-1-29",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-presentOnAdmission-cs-2-1-29\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-presentOnAdmission-cs-2-1-29</b></p><a name=\"hx1i-presentOnAdmission-cs-2-1-29\"> </a><a name=\"hchx1i-presentOnAdmission-cs-2-1-29\"> </a><p>Provenance for <a href=\"CodeSystem-presentOnAdmission.html\">CodeSystem CMS Present on Admission (POA) Indicator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2021-09-17</td></tr><tr><td>Recorded</td><td>2021-09-17 18:38:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/presentOnAdmission"
          }
        ],
        "occurredPeriod" : {
          "end" : "2021-09-17"
        },
        "recorded" : "2021-09-17T18:38:56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Adding codes the CMS Present on Admission (POA) Indicator code system stub; UP-214"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-CMSRxHCC-ns-3-0-5",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-CMSRxHCC-ns-3-0-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-CMSRxHCC-ns-3-0-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-CMSRxHCC-ns-3-0-5</b></p><a name=\"hx1i-CMSRxHCC-ns-3-0-5\"> </a><a name=\"hchx1i-CMSRxHCC-ns-3-0-5\"> </a><p>Provenance for <a href=\"NamingSystem-CMSRxHCC.html\">NamingSystem CMS Prescription Drug Hierarchical Condition Categories</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-01-29</td></tr><tr><td>Recorded</td><td>2022-01-29 00:43:55-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CMSRxHCC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-01-29"
        },
        "recorded" : "2022-01-29T00:43:55-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add CMS Prescription Drug Hierarchical Condition Categories per HTA; up-269"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-GTR-ns-3-0-6",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-GTR-ns-3-0-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-GTR-ns-3-0-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-GTR-ns-3-0-6</b></p><a name=\"hx1i-GTR-ns-3-0-6\"> </a><a name=\"hchx1i-GTR-ns-3-0-6\"> </a><p>Provenance for <a href=\"NamingSystem-GTR.html\">NamingSystem Genetic Testing Registry</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-02-10</td></tr><tr><td>Recorded</td><td>2022-02-10 10:43:44-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/GTR"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-02-10"
        },
        "recorded" : "2022-02-10T10:43:44-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add Genetic Testing Registry (GTR) per HTA; UP-282"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-X12ClaimAdjustmentReasonCodes-ns-3-1-13",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-X12ClaimAdjustmentReasonCodes-ns-3-1-13",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-X12ClaimAdjustmentReasonCodes-ns-3-1-13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-X12ClaimAdjustmentReasonCodes-ns-3-1-13</b></p><a name=\"hx1i-X12ClaimAdjustmentReasonCodes-ns-3-1-13\"> </a><a name=\"hchx1i-X12ClaimAdjustmentReasonCodes-ns-3-1-13\"> </a><p>Provenance for <a href=\"NamingSystem-X12ClaimAdjustmentReasonCodes.html\">NamingSystem X12 Claim Adjustment Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-08-02</td></tr><tr><td>Recorded</td><td>2022-08-02 11:30:10-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/X12ClaimAdjustmentReasonCodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-08-02"
        },
        "recorded" : "2022-08-02T11:30:10-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add X12 Claim Adjustment Reason Codes per HTA; up-328"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-CAPeCC-ns-3-1-20",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-CAPeCC-ns-3-1-20",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-CAPeCC-ns-3-1-20\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-CAPeCC-ns-3-1-20</b></p><a name=\"hx1i-CAPeCC-ns-3-1-20\"> </a><a name=\"hchx1i-CAPeCC-ns-3-1-20\"> </a><p>Provenance for <a href=\"NamingSystem-CAPeCC.html\">NamingSystem College of American Pathologists (CAP) eCC (electronic Cancer Checklists)</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-01</td></tr><tr><td>Recorded</td><td>2022-09-01 23:00:02-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/CAPeCC"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-01"
        },
        "recorded" : "2022-09-01T23:00:02-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add CAPeCC per HTA; up-332"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-HGNCGeneGroup-ns-3-1-21",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-HGNCGeneGroup-ns-3-1-21",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-HGNCGeneGroup-ns-3-1-21\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-HGNCGeneGroup-ns-3-1-21</b></p><a name=\"hx1i-HGNCGeneGroup-ns-3-1-21\"> </a><a name=\"hchx1i-HGNCGeneGroup-ns-3-1-21\"> </a><p>Provenance for <a href=\"NamingSystem-HGNCGeneGroup.html\">NamingSystem HUGO Gene Nomenclature Committee Gene Group</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-02</td></tr><tr><td>Recorded</td><td>2022-09-02 02:50:45-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/HGNCGeneGroup"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-02"
        },
        "recorded" : "2022-09-02T02:50:45-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add HGNC Code Systems per HTA; up-341"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-hgnc-ns-3-1-21",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-hgnc-ns-3-1-21",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-hgnc-ns-3-1-21\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-hgnc-ns-3-1-21</b></p><a name=\"hx1i-v3-hgnc-ns-3-1-21\"> </a><a name=\"hchx1i-v3-hgnc-ns-3-1-21\"> </a><p>Provenance for <a href=\"NamingSystem-v3-hgnc.html\">NamingSystem HUGO Gene Nomenclature Committee Genes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-02</td></tr><tr><td>Recorded</td><td>2022-09-02 02:51:44-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Jessica Bota</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>HTA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "NamingSystem/v3-hgnc"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-02"
        },
        "recorded" : "2022-09-02T02:51:44-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add HGNC Code Systems per HTA; up-341"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Jessica Bota"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "HTA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-encounter-subject-status-cs-3-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-encounter-subject-status-cs-3-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-encounter-subject-status-cs-3-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-encounter-subject-status-cs-3-1-24</b></p><a name=\"hx1i-encounter-subject-status-cs-3-1-24\"> </a><a name=\"hchx1i-encounter-subject-status-cs-3-1-24\"> </a><p>Provenance for <a href=\"CodeSystem-encounter-subject-status.html\">CodeSystem Encounter subject status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-04</td></tr><tr><td>Recorded</td><td>2022-09-04 13:33:14-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/encounter-subject-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-04"
        },
        "recorded" : "2022-09-04T13:33:14-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Apply Patient Admin approved Terminology changes; up-344"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-endpoint-connection-type-cs-3-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-endpoint-connection-type-cs-3-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-endpoint-connection-type-cs-3-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-endpoint-connection-type-cs-3-1-24</b></p><a name=\"hx1i-endpoint-connection-type-cs-3-1-24\"> </a><a name=\"hchx1i-endpoint-connection-type-cs-3-1-24\"> </a><p>Provenance for <a href=\"CodeSystem-endpoint-connection-type.html\">CodeSystem Endpoint Connection Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-04</td></tr><tr><td>Recorded</td><td>2022-09-04 13:35:31-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/endpoint-connection-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-04"
        },
        "recorded" : "2022-09-04T13:35:31-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Apply Patient Admin approved Terminology changes; up-344"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-endpoint-payload-type-cs-3-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-endpoint-payload-type-cs-3-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-endpoint-payload-type-cs-3-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-endpoint-payload-type-cs-3-1-24</b></p><a name=\"hx1i-endpoint-payload-type-cs-3-1-24\"> </a><a name=\"hchx1i-endpoint-payload-type-cs-3-1-24\"> </a><p>Provenance for <a href=\"CodeSystem-endpoint-payload-type.html\">CodeSystem Endpoint Payload Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-04</td></tr><tr><td>Recorded</td><td>2022-09-04 13:36:01-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/endpoint-payload-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-04"
        },
        "recorded" : "2022-09-04T13:36:01-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Apply Patient Admin approved Terminology changes; up-344"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-insurance-plan-type-cs-3-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-insurance-plan-type-cs-3-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-insurance-plan-type-cs-3-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-insurance-plan-type-cs-3-1-24</b></p><a name=\"hx1i-insurance-plan-type-cs-3-1-24\"> </a><a name=\"hchx1i-insurance-plan-type-cs-3-1-24\"> </a><p>Provenance for <a href=\"CodeSystem-insurance-plan-type.html\">CodeSystem Insurance plan type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-04</td></tr><tr><td>Recorded</td><td>2022-09-04 13:36:37-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/insurance-plan-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-04"
        },
        "recorded" : "2022-09-04T13:36:37-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Apply Patient Admin approved Terminology changes; up-344"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-location-physical-type-cs-3-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-location-physical-type-cs-3-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-location-physical-type-cs-3-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-location-physical-type-cs-3-1-24</b></p><a name=\"hx1i-location-physical-type-cs-3-1-24\"> </a><a name=\"hchx1i-location-physical-type-cs-3-1-24\"> </a><p>Provenance for <a href=\"CodeSystem-location-physical-type.html\">CodeSystem Location type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-04</td></tr><tr><td>Recorded</td><td>2022-09-04 13:37:12-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/location-physical-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-04"
        },
        "recorded" : "2022-09-04T13:37:12-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Apply Patient Admin approved Terminology changes; up-344"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-encounter-class-vs-3-1-24",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-encounter-class-vs-3-1-24",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-encounter-class-vs-3-1-24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-encounter-class-vs-3-1-24</b></p><a name=\"hx1i-encounter-class-vs-3-1-24\"> </a><a name=\"hchx1i-encounter-class-vs-3-1-24\"> </a><p>Provenance for <a href=\"ValueSet-encounter-class.html\">ValueSet Encounter class</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-09-04</td></tr><tr><td>Recorded</td><td>2022-09-04 13:37:49-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation CREATE}\">create</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Brian Postlethwaite</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>PA</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/encounter-class"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-09-04"
        },
        "recorded" : "2022-09-04T13:37:49-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Apply Patient Admin approved Terminology changes; up-344"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "CREATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Brian Postlethwaite"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "PA"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-Race-cs-3-0-3",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-Race-cs-3-0-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-Race-cs-3-0-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-Race-cs-3-0-3</b></p><a name=\"hx1i-v3-Race-cs-3-0-3\"> </a><a name=\"hchx1i-v3-Race-cs-3-0-3\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Race.html\">CodeSystem Race</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-20</td></tr><tr><td>Recorded</td><td>2022-10-20 01:54:25-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation DEPRECATE}\">deprecate</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Race"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-20"
        },
        "recorded" : "2022-10-20T01:54:25-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Deprecate the Race Code System in THO; up-263"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "DEPRECATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-Ethnicity-cs-3-0-4",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-Ethnicity-cs-3-0-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-Ethnicity-cs-3-0-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-Ethnicity-cs-3-0-4</b></p><a name=\"hx1i-v3-Ethnicity-cs-3-0-4\"> </a><a name=\"hchx1i-v3-Ethnicity-cs-3-0-4\"> </a><p>Provenance for <a href=\"CodeSystem-v3-Ethnicity.html\">CodeSystem Ethnicity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-20</td></tr><tr><td>Recorded</td><td>2022-10-20 01:55:03-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation DEPRECATE}\">deprecate</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>SD</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-Ethnicity"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-20"
        },
        "recorded" : "2022-10-20T01:55:03-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Deprecate the Ethnicity Code System in THO; up-265"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "DEPRECATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "SD"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-v3-ActCode-cs-3-0-8",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-v3-ActCode-cs-3-0-8",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-v3-ActCode-cs-3-0-8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-v3-ActCode-cs-3-0-8</b></p><a name=\"hx1i-v3-ActCode-cs-3-0-8\"> </a><a name=\"hchx1i-v3-ActCode-cs-3-0-8\"> </a><p>Provenance for <a href=\"CodeSystem-v3-ActCode.html\">CodeSystem ActCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2022-10-21</td></tr><tr><td>Recorded</td><td>2022-10-21 19:36:24-0600</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Yan Heras</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>CQI</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/v3-ActCode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2022-10-21"
        },
        "recorded" : "2022-10-21T19:36:24-06:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add new code CODINGGAP to ActCode; up-358"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Yan Heras"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "CQI"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-action-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-action-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-action-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-action-type-cs-5-3-9</b></p><a name=\"hx1i-action-type-cs-5-3-9\"> </a><a name=\"hchx1i-action-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-action-type.html\">CodeSystem ActionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/action-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:44.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-activity-definition-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-activity-definition-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-activity-definition-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-activity-definition-category-cs-5-3-9</b></p><a name=\"hx1i-activity-definition-category-cs-5-3-9\"> </a><a name=\"hchx1i-activity-definition-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-activity-definition-category.html\">CodeSystem ActivityDefinitionCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/activity-definition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:45.20-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adjudication-error-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adjudication-error-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adjudication-error-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adjudication-error-cs-5-3-9</b></p><a name=\"hx1i-adjudication-error-cs-5-3-9\"> </a><a name=\"hchx1i-adjudication-error-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adjudication-error.html\">CodeSystem Adjudication Error Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adjudication-error"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:45.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adjudication-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adjudication-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adjudication-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adjudication-reason-cs-5-3-9</b></p><a name=\"hx1i-adjudication-reason-cs-5-3-9\"> </a><a name=\"hchx1i-adjudication-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adjudication-reason.html\">CodeSystem Adjudication Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adjudication-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:46.25-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adjudication-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adjudication-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adjudication-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adjudication-cs-5-3-9</b></p><a name=\"hx1i-adjudication-cs-5-3-9\"> </a><a name=\"hchx1i-adjudication-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adjudication.html\">CodeSystem Adjudication Value Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adjudication"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:46.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-admit-source-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-admit-source-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-admit-source-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-admit-source-cs-5-3-9</b></p><a name=\"hx1i-admit-source-cs-5-3-9\"> </a><a name=\"hchx1i-admit-source-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-admit-source.html\">CodeSystem Admit source</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/admit-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:47.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-category-cs-5-3-9</b></p><a name=\"hx1i-adverse-event-category-cs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-category.html\">CodeSystem AdverseEventCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:47.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-causality-assess-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-causality-assess-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-causality-assess-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-causality-assess-cs-5-3-9</b></p><a name=\"hx1i-adverse-event-causality-assess-cs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-causality-assess-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-causality-assess.html\">CodeSystem AdverseEventCausalityAssessment</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-causality-assess"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:48.10-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-causality-method-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-causality-method-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-causality-method-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-causality-method-cs-5-3-9</b></p><a name=\"hx1i-adverse-event-causality-method-cs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-causality-method-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-causality-method.html\">CodeSystem AdverseEventCausalityMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-causality-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:48.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-seriousness-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-seriousness-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-seriousness-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-seriousness-cs-5-3-9</b></p><a name=\"hx1i-adverse-event-seriousness-cs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-seriousness-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-seriousness.html\">CodeSystem AdverseEventSeriousness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-seriousness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:49.08-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-severity-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-severity-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-severity-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-severity-cs-5-3-9</b></p><a name=\"hx1i-adverse-event-severity-cs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-severity-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-adverse-event-severity.html\">CodeSystem AdverseEventSeverity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/adverse-event-severity"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:49.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-allerg-intol-substance-exp-risk-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-allerg-intol-substance-exp-risk-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-allerg-intol-substance-exp-risk-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-allerg-intol-substance-exp-risk-cs-5-3-9</b></p><a name=\"hx1i-allerg-intol-substance-exp-risk-cs-5-3-9\"> </a><a name=\"hchx1i-allerg-intol-substance-exp-risk-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-allerg-intol-substance-exp-risk.html\">CodeSystem AllergyIntoleranceSubstanceExposureRisk</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/allerg-intol-substance-exp-risk"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:50.08-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-allergyintolerance-clinical-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-allergyintolerance-clinical-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-allergyintolerance-clinical-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-allergyintolerance-clinical-cs-5-3-9</b></p><a name=\"hx1i-allergyintolerance-clinical-cs-5-3-9\"> </a><a name=\"hchx1i-allergyintolerance-clinical-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-allergyintolerance-clinical.html\">CodeSystem AllergyIntolerance Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/allergyintolerance-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:50.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-allergyintolerance-verification-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-allergyintolerance-verification-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-allergyintolerance-verification-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-allergyintolerance-verification-cs-5-3-9</b></p><a name=\"hx1i-allergyintolerance-verification-cs-5-3-9\"> </a><a name=\"hchx1i-allergyintolerance-verification-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-allergyintolerance-verification.html\">CodeSystem AllergyIntolerance Verification Status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/allergyintolerance-verification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:51.10-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-applicability-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-applicability-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-applicability-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-applicability-cs-5-3-9</b></p><a name=\"hx1i-applicability-cs-5-3-9\"> </a><a name=\"hchx1i-applicability-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-applicability.html\">CodeSystem Benefit cost applicability</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/applicability"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:51.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-appointment-cancellation-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-appointment-cancellation-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-appointment-cancellation-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-appointment-cancellation-reason-cs-5-3-9</b></p><a name=\"hx1i-appointment-cancellation-reason-cs-5-3-9\"> </a><a name=\"hchx1i-appointment-cancellation-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-appointment-cancellation-reason.html\">CodeSystem Appointment cancellation reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/appointment-cancellation-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:52.14-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-appropriateness-score-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-appropriateness-score-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-appropriateness-score-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-appropriateness-score-cs-5-3-9</b></p><a name=\"hx1i-appropriateness-score-cs-5-3-9\"> </a><a name=\"hchx1i-appropriateness-score-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-appropriateness-score.html\">CodeSystem Appropriateness Score</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/appropriateness-score"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:52.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-attribute-estimate-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-attribute-estimate-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-attribute-estimate-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-attribute-estimate-type-cs-5-3-9</b></p><a name=\"hx1i-attribute-estimate-type-cs-5-3-9\"> </a><a name=\"hchx1i-attribute-estimate-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-attribute-estimate-type.html\">CodeSystem StatisticAttribute Estimate Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/attribute-estimate-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:53.19-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-audit-entity-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-audit-entity-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-audit-entity-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-audit-entity-type-cs-5-3-9</b></p><a name=\"hx1i-audit-entity-type-cs-5-3-9\"> </a><a name=\"hchx1i-audit-entity-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-audit-entity-type.html\">CodeSystem Audit event entity type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/audit-entity-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:53.72-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-audit-event-outcome-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-audit-event-outcome-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-audit-event-outcome-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-audit-event-outcome-cs-5-3-9</b></p><a name=\"hx1i-audit-event-outcome-cs-5-3-9\"> </a><a name=\"hchx1i-audit-event-outcome-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-audit-event-outcome.html\">CodeSystem AuditEventOutcome</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/audit-event-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:54.27-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-audit-event-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-audit-event-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-audit-event-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-audit-event-type-cs-5-3-9</b></p><a name=\"hx1i-audit-event-type-cs-5-3-9\"> </a><a name=\"hchx1i-audit-event-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-audit-event-type.html\">CodeSystem Audit Event ID</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/audit-event-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:54.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-basic-resource-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-basic-resource-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-basic-resource-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-basic-resource-type-cs-5-3-9</b></p><a name=\"hx1i-basic-resource-type-cs-5-3-9\"> </a><a name=\"hchx1i-basic-resource-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-basic-resource-type.html\">CodeSystem Basic Resource Types</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/basic-resource-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:55.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-network-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-network-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-network-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-network-cs-5-3-9</b></p><a name=\"hx1i-benefit-network-cs-5-3-9\"> </a><a name=\"hchx1i-benefit-network-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-network.html\">CodeSystem Network Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-network"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:55.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-term-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-term-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-term-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-term-cs-5-3-9</b></p><a name=\"hx1i-benefit-term-cs-5-3-9\"> </a><a name=\"hchx1i-benefit-term-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-term.html\">CodeSystem Benefit Term Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-term"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:56.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-type-cs-5-3-9</b></p><a name=\"hx1i-benefit-type-cs-5-3-9\"> </a><a name=\"hchx1i-benefit-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-type.html\">CodeSystem Benefit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:57.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-unit-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-unit-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-unit-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-unit-cs-5-3-9</b></p><a name=\"hx1i-benefit-unit-cs-5-3-9\"> </a><a name=\"hchx1i-benefit-unit-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-benefit-unit.html\">CodeSystem Unit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/benefit-unit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:57.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-can-push-updates-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-can-push-updates-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-can-push-updates-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-can-push-updates-cs-5-3-9</b></p><a name=\"hx1i-can-push-updates-cs-5-3-9\"> </a><a name=\"hchx1i-can-push-updates-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-can-push-updates.html\">CodeSystem Can-push-updates</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/can-push-updates"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:58.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-catalogType-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-catalogType-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-catalogType-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-catalogType-cs-5-3-9</b></p><a name=\"hx1i-catalogType-cs-5-3-9\"> </a><a name=\"hchx1i-catalogType-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-catalogType.html\">CodeSystem CatalogType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/catalogType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:59.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-cdshooks-indicator-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-cdshooks-indicator-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-cdshooks-indicator-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-cdshooks-indicator-cs-5-3-9</b></p><a name=\"hx1i-cdshooks-indicator-cs-5-3-9\"> </a><a name=\"hchx1i-cdshooks-indicator-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-cdshooks-indicator.html\">CodeSystem CDS Hooks Indicator</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:38:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/cdshooks-indicator"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:38:59.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-certainty-rating-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-certainty-rating-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-certainty-rating-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-certainty-rating-cs-5-3-9</b></p><a name=\"hx1i-certainty-rating-cs-5-3-9\"> </a><a name=\"hchx1i-certainty-rating-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-rating.html\">CodeSystem StatisticCertaintyRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:00.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-certainty-subcomponent-rating-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-certainty-subcomponent-rating-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-certainty-subcomponent-rating-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-certainty-subcomponent-rating-cs-5-3-9</b></p><a name=\"hx1i-certainty-subcomponent-rating-cs-5-3-9\"> </a><a name=\"hchx1i-certainty-subcomponent-rating-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-subcomponent-rating.html\">CodeSystem StatisticCertaintySubcomponentRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-subcomponent-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:00.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-certainty-subcomponent-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-certainty-subcomponent-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-certainty-subcomponent-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-certainty-subcomponent-type-cs-5-3-9</b></p><a name=\"hx1i-certainty-subcomponent-type-cs-5-3-9\"> </a><a name=\"hchx1i-certainty-subcomponent-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-certainty-subcomponent-type.html\">CodeSystem StatisticCertaintySubcomponentType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/certainty-subcomponent-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:01.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-characteristic-method-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-characteristic-method-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-characteristic-method-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-characteristic-method-cs-5-3-9</b></p><a name=\"hx1i-characteristic-method-cs-5-3-9\"> </a><a name=\"hchx1i-characteristic-method-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-characteristic-method.html\">CodeSystem CharacteristicMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/characteristic-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:02.18-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-chargeitem-billingcodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-chargeitem-billingcodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-chargeitem-billingcodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-chargeitem-billingcodes-cs-5-3-9</b></p><a name=\"hx1i-chargeitem-billingcodes-cs-5-3-9\"> </a><a name=\"hchx1i-chargeitem-billingcodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-chargeitem-billingcodes.html\">CodeSystem ChargeItemCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/chargeitem-billingcodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:02.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-choice-list-orientation-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-choice-list-orientation-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-choice-list-orientation-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-choice-list-orientation-cs-5-3-9</b></p><a name=\"hx1i-choice-list-orientation-cs-5-3-9\"> </a><a name=\"hchx1i-choice-list-orientation-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-choice-list-orientation.html\">CodeSystem ChoiceListOrientation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/choice-list-orientation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:03.43-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-chromosome-human-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-chromosome-human-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-chromosome-human-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-chromosome-human-cs-5-3-9</b></p><a name=\"hx1i-chromosome-human-cs-5-3-9\"> </a><a name=\"hchx1i-chromosome-human-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-chromosome-human.html\">CodeSystem chromosome-human</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/chromosome-human"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:04.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-exception-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-exception-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-exception-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-exception-cs-5-3-9</b></p><a name=\"hx1i-claim-exception-cs-5-3-9\"> </a><a name=\"hchx1i-claim-exception-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-claim-exception.html\">CodeSystem Exception Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claim-exception"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:04.67-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-type-cs-5-3-9</b></p><a name=\"hx1i-claim-type-cs-5-3-9\"> </a><a name=\"hchx1i-claim-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-claim-type.html\">CodeSystem Claim Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claim-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:05.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claimcareteamrole-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claimcareteamrole-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claimcareteamrole-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claimcareteamrole-cs-5-3-9</b></p><a name=\"hx1i-claimcareteamrole-cs-5-3-9\"> </a><a name=\"hchx1i-claimcareteamrole-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-claimcareteamrole.html\">CodeSystem Claim Care Team Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claimcareteamrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:05.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claiminformationcategory-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claiminformationcategory-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claiminformationcategory-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claiminformationcategory-cs-5-3-9</b></p><a name=\"hx1i-claiminformationcategory-cs-5-3-9\"> </a><a name=\"hchx1i-claiminformationcategory-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-claiminformationcategory.html\">CodeSystem Claim Information Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/claiminformationcategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:06.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-codesystem-altcode-kind-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-codesystem-altcode-kind-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-codesystem-altcode-kind-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-codesystem-altcode-kind-cs-5-3-9</b></p><a name=\"hx1i-codesystem-altcode-kind-cs-5-3-9\"> </a><a name=\"hchx1i-codesystem-altcode-kind-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-codesystem-altcode-kind.html\">CodeSystem AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/codesystem-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:07.18-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-common-tags-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-common-tags-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-common-tags-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-common-tags-cs-5-3-9</b></p><a name=\"hx1i-common-tags-cs-5-3-9\"> </a><a name=\"hchx1i-common-tags-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-common-tags.html\">CodeSystem Common Tags</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/common-tags"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:07.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-communication-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-communication-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-communication-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-communication-category-cs-5-3-9</b></p><a name=\"hx1i-communication-category-cs-5-3-9\"> </a><a name=\"hchx1i-communication-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-communication-category.html\">CodeSystem CommunicationCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/communication-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:08.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-communication-not-done-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-communication-not-done-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-communication-not-done-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-communication-not-done-reason-cs-5-3-9</b></p><a name=\"hx1i-communication-not-done-reason-cs-5-3-9\"> </a><a name=\"hchx1i-communication-not-done-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-communication-not-done-reason.html\">CodeSystem CommunicationNotDoneReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/communication-not-done-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:08.98-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-communication-topic-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-communication-topic-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-communication-topic-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-communication-topic-cs-5-3-9</b></p><a name=\"hx1i-communication-topic-cs-5-3-9\"> </a><a name=\"hchx1i-communication-topic-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-communication-topic.html\">CodeSystem CommunicationTopic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/communication-topic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:09.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-composite-measure-scoring-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-composite-measure-scoring-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-composite-measure-scoring-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-composite-measure-scoring-cs-5-3-9</b></p><a name=\"hx1i-composite-measure-scoring-cs-5-3-9\"> </a><a name=\"hchx1i-composite-measure-scoring-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-composite-measure-scoring.html\">CodeSystem CompositeMeasureScoring</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/composite-measure-scoring"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:10.19-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-composition-altcode-kind-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-composition-altcode-kind-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-composition-altcode-kind-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-composition-altcode-kind-cs-5-3-9</b></p><a name=\"hx1i-composition-altcode-kind-cs-5-3-9\"> </a><a name=\"hchx1i-composition-altcode-kind-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-composition-altcode-kind.html\">CodeSystem AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/composition-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:10.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-category-cs-5-3-9</b></p><a name=\"hx1i-condition-category-cs-5-3-9\"> </a><a name=\"hchx1i-condition-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-condition-category.html\">CodeSystem Condition Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:11.41-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-clinical-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-clinical-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-clinical-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-clinical-cs-5-3-9</b></p><a name=\"hx1i-condition-clinical-cs-5-3-9\"> </a><a name=\"hchx1i-condition-clinical-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-condition-clinical.html\">CodeSystem Condition Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:12.04-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-state-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-state-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-state-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-state-cs-5-3-9</b></p><a name=\"hx1i-condition-state-cs-5-3-9\"> </a><a name=\"hchx1i-condition-state-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-condition-state.html\">CodeSystem ConditionState</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:12.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-ver-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-ver-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-ver-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-ver-status-cs-5-3-9</b></p><a name=\"hx1i-condition-ver-status-cs-5-3-9\"> </a><a name=\"hchx1i-condition-ver-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-condition-ver-status.html\">CodeSystem ConditionVerificationStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/condition-ver-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:13.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-conformance-expectation-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-conformance-expectation-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-conformance-expectation-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-conformance-expectation-cs-5-3-9</b></p><a name=\"hx1i-conformance-expectation-cs-5-3-9\"> </a><a name=\"hchx1i-conformance-expectation-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-conformance-expectation.html\">CodeSystem ConformanceExpectation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/conformance-expectation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:13.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consentaction-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consentaction-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consentaction-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consentaction-cs-5-3-9</b></p><a name=\"hx1i-consentaction-cs-5-3-9\"> </a><a name=\"hchx1i-consentaction-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-consentaction.html\">CodeSystem Consent Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentaction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:14.47-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consentcategorycodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consentcategorycodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consentcategorycodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consentcategorycodes-cs-5-3-9</b></p><a name=\"hx1i-consentcategorycodes-cs-5-3-9\"> </a><a name=\"hchx1i-consentcategorycodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-consentcategorycodes.html\">CodeSystem Consent Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentcategorycodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:15.11-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consentpolicycodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consentpolicycodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consentpolicycodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consentpolicycodes-cs-5-3-9</b></p><a name=\"hx1i-consentpolicycodes-cs-5-3-9\"> </a><a name=\"hchx1i-consentpolicycodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-consentpolicycodes.html\">CodeSystem Consent PolicyRule Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentpolicycodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:15.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consentscope-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consentscope-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consentscope-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consentscope-cs-5-3-9</b></p><a name=\"hx1i-consentscope-cs-5-3-9\"> </a><a name=\"hchx1i-consentscope-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-consentscope.html\">CodeSystem Consent Scope Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentscope"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:16.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consentverification-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consentverification-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consentverification-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consentverification-cs-5-3-9</b></p><a name=\"hx1i-consentverification-cs-5-3-9\"> </a><a name=\"hchx1i-consentverification-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-consentverification.html\">CodeSystem Consent Verification Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/consentverification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:16.88-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contactentity-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contactentity-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contactentity-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contactentity-type-cs-5-3-9</b></p><a name=\"hx1i-contactentity-type-cs-5-3-9\"> </a><a name=\"hchx1i-contactentity-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contactentity-type.html\">CodeSystem Contact entity type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contactentity-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:17.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-container-cap-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-container-cap-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-container-cap-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-container-cap-cs-5-3-9</b></p><a name=\"hx1i-container-cap-cs-5-3-9\"> </a><a name=\"hchx1i-container-cap-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-container-cap.html\">CodeSystem ContainerCap</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/container-cap"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:18.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-content-derivative-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-content-derivative-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-content-derivative-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-content-derivative-cs-5-3-9</b></p><a name=\"hx1i-contract-content-derivative-cs-5-3-9\"> </a><a name=\"hchx1i-contract-content-derivative-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contract-content-derivative.html\">CodeSystem Contract Content Derivation Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contract-content-derivative"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:18.72-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-data-meaning-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-data-meaning-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-data-meaning-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-data-meaning-cs-5-3-9</b></p><a name=\"hx1i-contract-data-meaning-cs-5-3-9\"> </a><a name=\"hchx1i-contract-data-meaning-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contract-data-meaning.html\">CodeSystem ContractDataMeaning</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contract-data-meaning"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:19.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-type-cs-5-3-9</b></p><a name=\"hx1i-contract-type-cs-5-3-9\"> </a><a name=\"hchx1i-contract-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contract-type.html\">CodeSystem Contract Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contract-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:19.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contractaction-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contractaction-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contractaction-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contractaction-cs-5-3-9</b></p><a name=\"hx1i-contractaction-cs-5-3-9\"> </a><a name=\"hchx1i-contractaction-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contractaction.html\">CodeSystem Contract Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractaction"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:20.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contractactorrole-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contractactorrole-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contractactorrole-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contractactorrole-cs-5-3-9</b></p><a name=\"hx1i-contractactorrole-cs-5-3-9\"> </a><a name=\"hchx1i-contractactorrole-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contractactorrole.html\">CodeSystem Contract Actor Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractactorrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:21.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contractsignertypecodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contractsignertypecodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contractsignertypecodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contractsignertypecodes-cs-5-3-9</b></p><a name=\"hx1i-contractsignertypecodes-cs-5-3-9\"> </a><a name=\"hchx1i-contractsignertypecodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contractsignertypecodes.html\">CodeSystem Contract Signer Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractsignertypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:21.99-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contractsubtypecodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contractsubtypecodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contractsubtypecodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contractsubtypecodes-cs-5-3-9</b></p><a name=\"hx1i-contractsubtypecodes-cs-5-3-9\"> </a><a name=\"hchx1i-contractsubtypecodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contractsubtypecodes.html\">CodeSystem Contract Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contractsubtypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:22.67-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contracttermsubtypecodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contracttermsubtypecodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contracttermsubtypecodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contracttermsubtypecodes-cs-5-3-9</b></p><a name=\"hx1i-contracttermsubtypecodes-cs-5-3-9\"> </a><a name=\"hchx1i-contracttermsubtypecodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contracttermsubtypecodes.html\">CodeSystem Contract Term Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contracttermsubtypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:23.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contracttermtypecodes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contracttermtypecodes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contracttermtypecodes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contracttermtypecodes-cs-5-3-9</b></p><a name=\"hx1i-contracttermtypecodes-cs-5-3-9\"> </a><a name=\"hchx1i-contracttermtypecodes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-contracttermtypecodes.html\">CodeSystem Contract Term Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/contracttermtypecodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:23.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-copy-number-event-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-copy-number-event-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-copy-number-event-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-copy-number-event-cs-5-3-9</b></p><a name=\"hx1i-copy-number-event-cs-5-3-9\"> </a><a name=\"hchx1i-copy-number-event-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-copy-number-event.html\">CodeSystem CopyNumberEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/copy-number-event"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:24.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-coverage-class-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-coverage-class-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-coverage-class-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-coverage-class-cs-5-3-9</b></p><a name=\"hx1i-coverage-class-cs-5-3-9\"> </a><a name=\"hchx1i-coverage-class-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-coverage-class.html\">CodeSystem Coverage Class Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverage-class"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:25.16-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-coverage-copay-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-coverage-copay-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-coverage-copay-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-coverage-copay-type-cs-5-3-9</b></p><a name=\"hx1i-coverage-copay-type-cs-5-3-9\"> </a><a name=\"hchx1i-coverage-copay-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-coverage-copay-type.html\">CodeSystem Coverage Copay Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverage-copay-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:25.74-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-coverage-selfpay-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-coverage-selfpay-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-coverage-selfpay-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-coverage-selfpay-cs-5-3-9</b></p><a name=\"hx1i-coverage-selfpay-cs-5-3-9\"> </a><a name=\"hchx1i-coverage-selfpay-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-coverage-selfpay.html\">CodeSystem Coverage SelfPay Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverage-selfpay"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:26.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-coverageeligibilityresponse-ex-auth-support-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-coverageeligibilityresponse-ex-auth-support-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-coverageeligibilityresponse-ex-auth-support-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-coverageeligibilityresponse-ex-auth-support-cs-5-3-9</b></p><a name=\"hx1i-coverageeligibilityresponse-ex-auth-support-cs-5-3-9\"> </a><a name=\"hchx1i-coverageeligibilityresponse-ex-auth-support-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-coverageeligibilityresponse-ex-auth-support.html\">CodeSystem CoverageEligibilityResponse Auth Support Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/coverageeligibilityresponse-ex-auth-support"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:27.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-data-absent-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-data-absent-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-data-absent-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-data-absent-reason-cs-5-3-9</b></p><a name=\"hx1i-data-absent-reason-cs-5-3-9\"> </a><a name=\"hchx1i-data-absent-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-data-absent-reason.html\">CodeSystem DataAbsentReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/data-absent-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:27.77-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-definition-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-definition-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-definition-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-definition-status-cs-5-3-9</b></p><a name=\"hx1i-definition-status-cs-5-3-9\"> </a><a name=\"hchx1i-definition-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-definition-status.html\">CodeSystem DefinitionStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/definition-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:28.49-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-definition-topic-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-definition-topic-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-definition-topic-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-definition-topic-cs-5-3-9</b></p><a name=\"hx1i-definition-topic-cs-5-3-9\"> </a><a name=\"hchx1i-definition-topic-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-definition-topic.html\">CodeSystem DefinitionTopic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/definition-topic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:29.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-definition-use-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-definition-use-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-definition-use-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-definition-use-cs-5-3-9</b></p><a name=\"hx1i-definition-use-cs-5-3-9\"> </a><a name=\"hchx1i-definition-use-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-definition-use.html\">CodeSystem Structure Definition Use Codes / Keywords</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/definition-use"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:29.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-device-status-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-device-status-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-device-status-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-device-status-reason-cs-5-3-9</b></p><a name=\"hx1i-device-status-reason-cs-5-3-9\"> </a><a name=\"hchx1i-device-status-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-device-status-reason.html\">CodeSystem FHIRDeviceStatusReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/device-status-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:30.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-diagnosis-role-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-diagnosis-role-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-diagnosis-role-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-diagnosis-role-cs-5-3-9</b></p><a name=\"hx1i-diagnosis-role-cs-5-3-9\"> </a><a name=\"hchx1i-diagnosis-role-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-diagnosis-role.html\">CodeSystem Diagnosis Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/diagnosis-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:31.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-dicom-audit-lifecycle-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-dicom-audit-lifecycle-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-dicom-audit-lifecycle-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-dicom-audit-lifecycle-cs-5-3-9</b></p><a name=\"hx1i-dicom-audit-lifecycle-cs-5-3-9\"> </a><a name=\"hchx1i-dicom-audit-lifecycle-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-dicom-audit-lifecycle.html\">CodeSystem DICOM Audit Message Record Lifecycle Events</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/dicom-audit-lifecycle"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:31.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-diet-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-diet-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-diet-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-diet-cs-5-3-9</b></p><a name=\"hx1i-diet-cs-5-3-9\"> </a><a name=\"hchx1i-diet-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-diet.html\">CodeSystem Diet</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/diet"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:32.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-directness-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-directness-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-directness-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-directness-cs-5-3-9</b></p><a name=\"hx1i-directness-cs-5-3-9\"> </a><a name=\"hchx1i-directness-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-directness.html\">CodeSystem EvidenceDirectness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/directness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:33.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-discharge-disposition-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-discharge-disposition-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-discharge-disposition-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-discharge-disposition-cs-5-3-9</b></p><a name=\"hx1i-discharge-disposition-cs-5-3-9\"> </a><a name=\"hchx1i-discharge-disposition-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-discharge-disposition.html\">CodeSystem Discharge disposition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/discharge-disposition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:33.88-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-dose-rate-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-dose-rate-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-dose-rate-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-dose-rate-type-cs-5-3-9</b></p><a name=\"hx1i-dose-rate-type-cs-5-3-9\"> </a><a name=\"hchx1i-dose-rate-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-dose-rate-type.html\">CodeSystem DoseAndRateType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/dose-rate-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:34.47-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-encounter-special-arrangements-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-encounter-special-arrangements-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-encounter-special-arrangements-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-encounter-special-arrangements-cs-5-3-9</b></p><a name=\"hx1i-encounter-special-arrangements-cs-5-3-9\"> </a><a name=\"hchx1i-encounter-special-arrangements-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-encounter-special-arrangements.html\">CodeSystem Special arrangements</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/encounter-special-arrangements"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:35.11-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-encounter-subject-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-encounter-subject-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-encounter-subject-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-encounter-subject-status-cs-5-3-9</b></p><a name=\"hx1i-encounter-subject-status-cs-5-3-9\"> </a><a name=\"hchx1i-encounter-subject-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-encounter-subject-status.html\">CodeSystem Encounter subject status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/encounter-subject-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:35.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-encounter-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-encounter-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-encounter-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-encounter-type-cs-5-3-9</b></p><a name=\"hx1i-encounter-type-cs-5-3-9\"> </a><a name=\"hchx1i-encounter-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-encounter-type.html\">CodeSystem Encounter type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/encounter-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:36.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-endpoint-connection-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-endpoint-connection-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-endpoint-connection-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-endpoint-connection-type-cs-5-3-9</b></p><a name=\"hx1i-endpoint-connection-type-cs-5-3-9\"> </a><a name=\"hchx1i-endpoint-connection-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-endpoint-connection-type.html\">CodeSystem Endpoint Connection Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/endpoint-connection-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:37.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-endpoint-payload-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-endpoint-payload-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-endpoint-payload-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-endpoint-payload-type-cs-5-3-9</b></p><a name=\"hx1i-endpoint-payload-type-cs-5-3-9\"> </a><a name=\"hchx1i-endpoint-payload-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-endpoint-payload-type.html\">CodeSystem Endpoint Payload Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/endpoint-payload-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:37.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-entformula-additive-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-entformula-additive-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-entformula-additive-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-entformula-additive-cs-5-3-9</b></p><a name=\"hx1i-entformula-additive-cs-5-3-9\"> </a><a name=\"hchx1i-entformula-additive-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-entformula-additive.html\">CodeSystem Enteral Formula Additive Type Code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/entformula-additive"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:38.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-episodeofcare-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-episodeofcare-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-episodeofcare-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-episodeofcare-type-cs-5-3-9</b></p><a name=\"hx1i-episodeofcare-type-cs-5-3-9\"> </a><a name=\"hchx1i-episodeofcare-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-episodeofcare-type.html\">CodeSystem Episode of care type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/episodeofcare-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:39.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-evidence-quality-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-evidence-quality-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-evidence-quality-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-evidence-quality-cs-5-3-9</b></p><a name=\"hx1i-evidence-quality-cs-5-3-9\"> </a><a name=\"hchx1i-evidence-quality-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-evidence-quality.html\">CodeSystem QualityOfEvidenceRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/evidence-quality"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:39.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-benefitcategory-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-benefitcategory-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-benefitcategory-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-benefitcategory-cs-5-3-9</b></p><a name=\"hx1i-ex-benefitcategory-cs-5-3-9\"> </a><a name=\"hchx1i-ex-benefitcategory-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-benefitcategory.html\">CodeSystem Benefit Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-benefitcategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:40.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-claimsubtype-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-claimsubtype-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-claimsubtype-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-claimsubtype-cs-5-3-9</b></p><a name=\"hx1i-ex-claimsubtype-cs-5-3-9\"> </a><a name=\"hchx1i-ex-claimsubtype-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-claimsubtype.html\">CodeSystem Example Claim SubType Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-claimsubtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:41.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-coverage-financial-exception-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-coverage-financial-exception-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-coverage-financial-exception-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-coverage-financial-exception-cs-5-3-9</b></p><a name=\"hx1i-ex-coverage-financial-exception-cs-5-3-9\"> </a><a name=\"hchx1i-ex-coverage-financial-exception-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-coverage-financial-exception.html\">CodeSystem Example Coverage Financial Exception Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-coverage-financial-exception"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:42.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-diagnosis-on-admission-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-diagnosis-on-admission-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-diagnosis-on-admission-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-diagnosis-on-admission-cs-5-3-9</b></p><a name=\"hx1i-ex-diagnosis-on-admission-cs-5-3-9\"> </a><a name=\"hchx1i-ex-diagnosis-on-admission-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-diagnosis-on-admission.html\">CodeSystem Example Diagnosis on Admission Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-diagnosis-on-admission"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:42.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-diagnosisrelatedgroup-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-diagnosisrelatedgroup-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-diagnosisrelatedgroup-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-diagnosisrelatedgroup-cs-5-3-9</b></p><a name=\"hx1i-ex-diagnosisrelatedgroup-cs-5-3-9\"> </a><a name=\"hchx1i-ex-diagnosisrelatedgroup-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-diagnosisrelatedgroup.html\">CodeSystem Example Diagnosis Related Group Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-diagnosisrelatedgroup"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:43.25-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-diagnosistype-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-diagnosistype-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-diagnosistype-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-diagnosistype-cs-5-3-9</b></p><a name=\"hx1i-ex-diagnosistype-cs-5-3-9\"> </a><a name=\"hchx1i-ex-diagnosistype-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-diagnosistype.html\">CodeSystem Example Diagnosis Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-diagnosistype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:43.96-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-payee-resource-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-payee-resource-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-payee-resource-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-payee-resource-type-cs-5-3-9</b></p><a name=\"hx1i-ex-payee-resource-type-cs-5-3-9\"> </a><a name=\"hchx1i-ex-payee-resource-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-payee-resource-type.html\">CodeSystem ClaimPayeeResourceType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-payee-resource-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:44.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-paymenttype-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-paymenttype-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-paymenttype-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-paymenttype-cs-5-3-9</b></p><a name=\"hx1i-ex-paymenttype-cs-5-3-9\"> </a><a name=\"hchx1i-ex-paymenttype-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-paymenttype.html\">CodeSystem Example Payment Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-paymenttype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:45.75-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-procedure-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-procedure-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-procedure-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-procedure-type-cs-5-3-9</b></p><a name=\"hx1i-ex-procedure-type-cs-5-3-9\"> </a><a name=\"hchx1i-ex-procedure-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-procedure-type.html\">CodeSystem Example Procedure Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-procedure-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:46.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-programcode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-programcode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-programcode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-programcode-cs-5-3-9</b></p><a name=\"hx1i-ex-programcode-cs-5-3-9\"> </a><a name=\"hchx1i-ex-programcode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-programcode.html\">CodeSystem Example Program Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-programcode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:46.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-providerqualification-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-providerqualification-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-providerqualification-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-providerqualification-cs-5-3-9</b></p><a name=\"hx1i-ex-providerqualification-cs-5-3-9\"> </a><a name=\"hchx1i-ex-providerqualification-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-providerqualification.html\">CodeSystem Example Provider Qualification Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-providerqualification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:47.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-relatedclaimrelationship-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-relatedclaimrelationship-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-relatedclaimrelationship-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-relatedclaimrelationship-cs-5-3-9</b></p><a name=\"hx1i-ex-relatedclaimrelationship-cs-5-3-9\"> </a><a name=\"hchx1i-ex-relatedclaimrelationship-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-relatedclaimrelationship.html\">CodeSystem Example Related Claim Relationship Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-relatedclaimrelationship"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:48.25-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-revenue-center-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-revenue-center-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-revenue-center-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-revenue-center-cs-5-3-9</b></p><a name=\"hx1i-ex-revenue-center-cs-5-3-9\"> </a><a name=\"hchx1i-ex-revenue-center-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-revenue-center.html\">CodeSystem Example Revenue Center Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-revenue-center"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:48.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-serviceplace-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-serviceplace-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-serviceplace-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-serviceplace-cs-5-3-9</b></p><a name=\"hx1i-ex-serviceplace-cs-5-3-9\"> </a><a name=\"hchx1i-ex-serviceplace-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-serviceplace.html\">CodeSystem Example Service Place Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-serviceplace"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:49.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-tooth-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-tooth-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-tooth-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-tooth-cs-5-3-9</b></p><a name=\"hx1i-ex-tooth-cs-5-3-9\"> </a><a name=\"hchx1i-ex-tooth-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-tooth.html\">CodeSystem Oral Site Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-tooth"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:50.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-USCLS-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-USCLS-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-USCLS-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-USCLS-cs-5-3-9</b></p><a name=\"hx1i-ex-USCLS-cs-5-3-9\"> </a><a name=\"hchx1i-ex-USCLS-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-USCLS.html\">CodeSystem USCLS Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-USCLS"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:51.07-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-ex-visionprescriptionproduct-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-ex-visionprescriptionproduct-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-ex-visionprescriptionproduct-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-ex-visionprescriptionproduct-cs-5-3-9</b></p><a name=\"hx1i-ex-visionprescriptionproduct-cs-5-3-9\"> </a><a name=\"hchx1i-ex-visionprescriptionproduct-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-ex-visionprescriptionproduct.html\">CodeSystem Example Vision Prescription Product Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/ex-visionprescriptionproduct"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:51.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-expansion-parameter-source-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-expansion-parameter-source-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-expansion-parameter-source-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-expansion-parameter-source-cs-5-3-9</b></p><a name=\"hx1i-expansion-parameter-source-cs-5-3-9\"> </a><a name=\"hchx1i-expansion-parameter-source-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-expansion-parameter-source.html\">CodeSystem ExpansionParameterSource</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/expansion-parameter-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:52.31-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-expansion-processing-rule-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-expansion-processing-rule-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-expansion-processing-rule-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-expansion-processing-rule-cs-5-3-9</b></p><a name=\"hx1i-expansion-processing-rule-cs-5-3-9\"> </a><a name=\"hchx1i-expansion-processing-rule-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-expansion-processing-rule.html\">CodeSystem ExpansionProcessingRule</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:52-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/expansion-processing-rule"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:52.99-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-extra-security-role-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-extra-security-role-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-extra-security-role-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-extra-security-role-type-cs-5-3-9</b></p><a name=\"hx1i-extra-security-role-type-cs-5-3-9\"> </a><a name=\"hchx1i-extra-security-role-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-extra-security-role-type.html\">CodeSystem Security Role Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/extra-security-role-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:53.62-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-failure-action-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-failure-action-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-failure-action-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-failure-action-cs-5-3-9</b></p><a name=\"hx1i-failure-action-cs-5-3-9\"> </a><a name=\"hchx1i-failure-action-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-failure-action.html\">CodeSystem Failure-action</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/failure-action"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:54.38-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-FDI-surface-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-FDI-surface-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-FDI-surface-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-FDI-surface-cs-5-3-9</b></p><a name=\"hx1i-FDI-surface-cs-5-3-9\"> </a><a name=\"hchx1i-FDI-surface-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-FDI-surface.html\">CodeSystem Surface Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/FDI-surface"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:55.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-financialtaskcode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-financialtaskcode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-financialtaskcode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-financialtaskcode-cs-5-3-9</b></p><a name=\"hx1i-financialtaskcode-cs-5-3-9\"> </a><a name=\"hchx1i-financialtaskcode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-financialtaskcode.html\">CodeSystem Financial Task Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/financialtaskcode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:55.78-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-financialtaskinputtype-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-financialtaskinputtype-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-financialtaskinputtype-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-financialtaskinputtype-cs-5-3-9</b></p><a name=\"hx1i-financialtaskinputtype-cs-5-3-9\"> </a><a name=\"hchx1i-financialtaskinputtype-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-financialtaskinputtype.html\">CodeSystem Financial Task Input Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/financialtaskinputtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:56.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-flag-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-flag-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-flag-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-flag-category-cs-5-3-9</b></p><a name=\"hx1i-flag-category-cs-5-3-9\"> </a><a name=\"hchx1i-flag-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-flag-category.html\">CodeSystem Flag Category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/flag-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:57.18-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-forms-codes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-forms-codes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-forms-codes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-forms-codes-cs-5-3-9</b></p><a name=\"hx1i-forms-codes-cs-5-3-9\"> </a><a name=\"hchx1i-forms-codes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-forms-codes.html\">CodeSystem Form Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/forms-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:57.90-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-fundsreserve-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-fundsreserve-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-fundsreserve-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-fundsreserve-cs-5-3-9</b></p><a name=\"hx1i-fundsreserve-cs-5-3-9\"> </a><a name=\"hchx1i-fundsreserve-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-fundsreserve.html\">CodeSystem Funds Reservation Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/fundsreserve"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:58.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-goal-acceptance-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-goal-acceptance-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-goal-acceptance-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-goal-acceptance-status-cs-5-3-9</b></p><a name=\"hx1i-goal-acceptance-status-cs-5-3-9\"> </a><a name=\"hchx1i-goal-acceptance-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-goal-acceptance-status.html\">CodeSystem GoalAcceptanceStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-acceptance-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:59.23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-goal-achievement-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-goal-achievement-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-goal-achievement-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-goal-achievement-cs-5-3-9</b></p><a name=\"hx1i-goal-achievement-cs-5-3-9\"> </a><a name=\"hchx1i-goal-achievement-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-goal-achievement.html\">CodeSystem Goal achievement status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:39:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-achievement"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:39:59.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-goal-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-goal-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-goal-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-goal-category-cs-5-3-9</b></p><a name=\"hx1i-goal-category-cs-5-3-9\"> </a><a name=\"hchx1i-goal-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-goal-category.html\">CodeSystem Goal category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:00.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-goal-priority-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-goal-priority-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-goal-priority-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-goal-priority-cs-5-3-9</b></p><a name=\"hx1i-goal-priority-cs-5-3-9\"> </a><a name=\"hchx1i-goal-priority-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-goal-priority.html\">CodeSystem Goal priority</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-priority"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:01.13-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-goal-relationship-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-goal-relationship-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-goal-relationship-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-goal-relationship-type-cs-5-3-9</b></p><a name=\"hx1i-goal-relationship-type-cs-5-3-9\"> </a><a name=\"hchx1i-goal-relationship-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-goal-relationship-type.html\">CodeSystem GoalRelationshipType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/goal-relationship-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:01.81-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-guide-parameter-code-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-guide-parameter-code-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-guide-parameter-code-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-guide-parameter-code-cs-5-3-9</b></p><a name=\"hx1i-guide-parameter-code-cs-5-3-9\"> </a><a name=\"hchx1i-guide-parameter-code-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-guide-parameter-code.html\">CodeSystem GuideParameterCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/guide-parameter-code"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:02.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-handling-condition-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-handling-condition-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-handling-condition-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-handling-condition-cs-5-3-9</b></p><a name=\"hx1i-handling-condition-cs-5-3-9\"> </a><a name=\"hchx1i-handling-condition-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-handling-condition.html\">CodeSystem HandlingConditionSet</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/handling-condition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:03.45-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-history-absent-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-history-absent-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-history-absent-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-history-absent-reason-cs-5-3-9</b></p><a name=\"hx1i-history-absent-reason-cs-5-3-9\"> </a><a name=\"hchx1i-history-absent-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-history-absent-reason.html\">CodeSystem FamilyHistoryAbsentReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/history-absent-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:04.13-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-immunization-evaluation-dose-status-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-immunization-evaluation-dose-status-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-immunization-evaluation-dose-status-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-immunization-evaluation-dose-status-reason-cs-5-3-9</b></p><a name=\"hx1i-immunization-evaluation-dose-status-reason-cs-5-3-9\"> </a><a name=\"hchx1i-immunization-evaluation-dose-status-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-evaluation-dose-status-reason.html\">CodeSystem Immunization Evaluation Dose Status Reason codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-evaluation-dose-status-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:04.87-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-immunization-evaluation-dose-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-immunization-evaluation-dose-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-immunization-evaluation-dose-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-immunization-evaluation-dose-status-cs-5-3-9</b></p><a name=\"hx1i-immunization-evaluation-dose-status-cs-5-3-9\"> </a><a name=\"hchx1i-immunization-evaluation-dose-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-evaluation-dose-status.html\">CodeSystem Immunization Evaluation Dose Status codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-evaluation-dose-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:05.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-immunization-funding-source-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-immunization-funding-source-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-immunization-funding-source-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-immunization-funding-source-cs-5-3-9</b></p><a name=\"hx1i-immunization-funding-source-cs-5-3-9\"> </a><a name=\"hchx1i-immunization-funding-source-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-funding-source.html\">CodeSystem Immunization Funding Source</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-funding-source"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:06.45-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-immunization-origin-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-immunization-origin-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-immunization-origin-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-immunization-origin-cs-5-3-9</b></p><a name=\"hx1i-immunization-origin-cs-5-3-9\"> </a><a name=\"hchx1i-immunization-origin-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-origin.html\">CodeSystem Immunization Origin Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-origin"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:07.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-immunization-program-eligibility-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-immunization-program-eligibility-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-immunization-program-eligibility-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-immunization-program-eligibility-cs-5-3-9</b></p><a name=\"hx1i-immunization-program-eligibility-cs-5-3-9\"> </a><a name=\"hchx1i-immunization-program-eligibility-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-program-eligibility.html\">CodeSystem Immunization Program Eligibility</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-program-eligibility"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:08.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-immunization-recommendation-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-immunization-recommendation-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-immunization-recommendation-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-immunization-recommendation-status-cs-5-3-9</b></p><a name=\"hx1i-immunization-recommendation-status-cs-5-3-9\"> </a><a name=\"hchx1i-immunization-recommendation-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-recommendation-status.html\">CodeSystem Immunization Recommendation Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-recommendation-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:08.70-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-immunization-subpotent-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-immunization-subpotent-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-immunization-subpotent-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-immunization-subpotent-reason-cs-5-3-9</b></p><a name=\"hx1i-immunization-subpotent-reason-cs-5-3-9\"> </a><a name=\"hchx1i-immunization-subpotent-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-immunization-subpotent-reason.html\">CodeSystem Immunization Subpotent Reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/immunization-subpotent-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:09.39-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-implantStatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-implantStatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-implantStatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-implantStatus-cs-5-3-9</b></p><a name=\"hx1i-implantStatus-cs-5-3-9\"> </a><a name=\"hchx1i-implantStatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-implantStatus.html\">CodeSystem Implant Status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/implantStatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:10.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-insurance-plan-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-insurance-plan-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-insurance-plan-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-insurance-plan-type-cs-5-3-9</b></p><a name=\"hx1i-insurance-plan-type-cs-5-3-9\"> </a><a name=\"hchx1i-insurance-plan-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-insurance-plan-type.html\">CodeSystem Insurance plan type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/insurance-plan-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:10.75-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-iso-21089-lifecycle-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-iso-21089-lifecycle-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-iso-21089-lifecycle-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-iso-21089-lifecycle-cs-5-3-9</b></p><a name=\"hx1i-iso-21089-lifecycle-cs-5-3-9\"> </a><a name=\"hchx1i-iso-21089-lifecycle-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-iso-21089-lifecycle.html\">CodeSystem ISO 21089 2017 Health Record Lifecycle Events</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/iso-21089-lifecycle"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:11.41-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-library-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-library-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-library-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-library-type-cs-5-3-9</b></p><a name=\"hx1i-library-type-cs-5-3-9\"> </a><a name=\"hchx1i-library-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-library-type.html\">CodeSystem LibraryType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/library-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:12.14-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-list-empty-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-list-empty-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-list-empty-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-list-empty-reason-cs-5-3-9</b></p><a name=\"hx1i-list-empty-reason-cs-5-3-9\"> </a><a name=\"hchx1i-list-empty-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-list-empty-reason.html\">CodeSystem List Empty Reasons</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/list-empty-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:12.90-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-list-example-use-codes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-list-example-use-codes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-list-example-use-codes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-list-example-use-codes-cs-5-3-9</b></p><a name=\"hx1i-list-example-use-codes-cs-5-3-9\"> </a><a name=\"hchx1i-list-example-use-codes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-list-example-use-codes.html\">CodeSystem Example Use Codes for List</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/list-example-use-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:13.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-list-order-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-list-order-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-list-order-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-list-order-cs-5-3-9</b></p><a name=\"hx1i-list-order-cs-5-3-9\"> </a><a name=\"hchx1i-list-order-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-list-order.html\">CodeSystem List Order Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/list-order"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:14.23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-location-physical-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-location-physical-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-location-physical-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-location-physical-type-cs-5-3-9</b></p><a name=\"hx1i-location-physical-type-cs-5-3-9\"> </a><a name=\"hchx1i-location-physical-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-location-physical-type.html\">CodeSystem Location type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/location-physical-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:15.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-match-grade-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-match-grade-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-match-grade-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-match-grade-cs-5-3-9</b></p><a name=\"hx1i-match-grade-cs-5-3-9\"> </a><a name=\"hchx1i-match-grade-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-match-grade.html\">CodeSystem MatchGrade</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/match-grade"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:15.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-measure-aggregate-method-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-measure-aggregate-method-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-measure-aggregate-method-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-measure-aggregate-method-cs-5-3-9</b></p><a name=\"hx1i-measure-aggregate-method-cs-5-3-9\"> </a><a name=\"hchx1i-measure-aggregate-method-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-measure-aggregate-method.html\">CodeSystem Measure Aggregate Method</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-aggregate-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:16.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-measure-data-usage-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-measure-data-usage-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-measure-data-usage-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-measure-data-usage-cs-5-3-9</b></p><a name=\"hx1i-measure-data-usage-cs-5-3-9\"> </a><a name=\"hchx1i-measure-data-usage-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-measure-data-usage.html\">CodeSystem MeasureDataUsage</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-data-usage"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:17.18-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-measure-improvement-notation-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-measure-improvement-notation-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-measure-improvement-notation-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-measure-improvement-notation-cs-5-3-9</b></p><a name=\"hx1i-measure-improvement-notation-cs-5-3-9\"> </a><a name=\"hchx1i-measure-improvement-notation-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-measure-improvement-notation.html\">CodeSystem MeasureImprovementNotation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-improvement-notation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:18.22-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-measure-population-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-measure-population-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-measure-population-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-measure-population-cs-5-3-9</b></p><a name=\"hx1i-measure-population-cs-5-3-9\"> </a><a name=\"hchx1i-measure-population-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-measure-population.html\">CodeSystem Measure Population Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-population"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:18.86-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-measure-scoring-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-measure-scoring-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-measure-scoring-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-measure-scoring-cs-5-3-9</b></p><a name=\"hx1i-measure-scoring-cs-5-3-9\"> </a><a name=\"hchx1i-measure-scoring-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-measure-scoring.html\">CodeSystem Measure Scoring</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-scoring"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:19.49-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-measure-supplemental-data-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-measure-supplemental-data-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-measure-supplemental-data-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-measure-supplemental-data-cs-5-3-9</b></p><a name=\"hx1i-measure-supplemental-data-cs-5-3-9\"> </a><a name=\"hchx1i-measure-supplemental-data-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-measure-supplemental-data.html\">CodeSystem Measure Supplemental Data</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-supplemental-data"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:20.15-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-measure-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-measure-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-measure-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-measure-type-cs-5-3-9</b></p><a name=\"hx1i-measure-type-cs-5-3-9\"> </a><a name=\"hchx1i-measure-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-measure-type.html\">CodeSystem MeasureType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/measure-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:20.79-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-med-admin-perform-function-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-med-admin-perform-function-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-med-admin-perform-function-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-med-admin-perform-function-cs-5-3-9</b></p><a name=\"hx1i-med-admin-perform-function-cs-5-3-9\"> </a><a name=\"hchx1i-med-admin-perform-function-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-med-admin-perform-function.html\">CodeSystem MedicationAdministration Performer Function Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/med-admin-perform-function"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:21.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-media-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-media-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-media-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-media-category-cs-5-3-9</b></p><a name=\"hx1i-media-category-cs-5-3-9\"> </a><a name=\"hchx1i-media-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-media-category.html\">CodeSystem Digital Media Category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/media-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:22.16-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medication-admin-location-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medication-admin-location-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medication-admin-location-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medication-admin-location-cs-5-3-9</b></p><a name=\"hx1i-medication-admin-location-cs-5-3-9\"> </a><a name=\"hchx1i-medication-admin-location-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medication-admin-location.html\">CodeSystem MedicationAdministration Location Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medication-admin-location"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:22.84-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medication-usage-admin-location-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medication-usage-admin-location-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medication-usage-admin-location-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medication-usage-admin-location-cs-5-3-9</b></p><a name=\"hx1i-medication-usage-admin-location-cs-5-3-9\"> </a><a name=\"hchx1i-medication-usage-admin-location-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medication-usage-admin-location.html\">CodeSystem MedicationUsage Administration Location Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medication-usage-admin-location"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:23.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationdispense-performer-function-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationdispense-performer-function-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationdispense-performer-function-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationdispense-performer-function-cs-5-3-9</b></p><a name=\"hx1i-medicationdispense-performer-function-cs-5-3-9\"> </a><a name=\"hchx1i-medicationdispense-performer-function-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationdispense-performer-function.html\">CodeSystem MedicationDispense Performer Function Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationdispense-performer-function"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:24.27-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationknowledge-characteristic-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationknowledge-characteristic-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationknowledge-characteristic-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationknowledge-characteristic-cs-5-3-9</b></p><a name=\"hx1i-medicationknowledge-characteristic-cs-5-3-9\"> </a><a name=\"hchx1i-medicationknowledge-characteristic-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationknowledge-characteristic.html\">CodeSystem MedicationKnowledge Characteristic Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationknowledge-characteristic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:24.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationknowledge-package-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationknowledge-package-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationknowledge-package-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationknowledge-package-type-cs-5-3-9</b></p><a name=\"hx1i-medicationknowledge-package-type-cs-5-3-9\"> </a><a name=\"hchx1i-medicationknowledge-package-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationknowledge-package-type.html\">CodeSystem MedicationKnowledge Package Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationknowledge-package-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:25.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationknowledge-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationknowledge-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationknowledge-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationknowledge-status-cs-5-3-9</b></p><a name=\"hx1i-medicationknowledge-status-cs-5-3-9\"> </a><a name=\"hchx1i-medicationknowledge-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationknowledge-status.html\">CodeSystem MedicationKnowledge Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationknowledge-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:26.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationrequest-admin-location-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationrequest-admin-location-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationrequest-admin-location-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationrequest-admin-location-cs-5-3-9</b></p><a name=\"hx1i-medicationrequest-admin-location-cs-5-3-9\"> </a><a name=\"hchx1i-medicationrequest-admin-location-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-admin-location.html\">CodeSystem Medication request  administration  location  codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-admin-location"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:26.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationrequest-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationrequest-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationrequest-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationrequest-category-cs-5-3-9</b></p><a name=\"hx1i-medicationrequest-category-cs-5-3-9\"> </a><a name=\"hchx1i-medicationrequest-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-category.html\">CodeSystem MedicationRequest Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:27.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationrequest-course-of-therapy-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationrequest-course-of-therapy-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationrequest-course-of-therapy-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationrequest-course-of-therapy-cs-5-3-9</b></p><a name=\"hx1i-medicationrequest-course-of-therapy-cs-5-3-9\"> </a><a name=\"hchx1i-medicationrequest-course-of-therapy-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-course-of-therapy.html\">CodeSystem MedicationRequest Course of Therapy Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-course-of-therapy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:28.38-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-medicationrequest-status-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-medicationrequest-status-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-medicationrequest-status-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-medicationrequest-status-reason-cs-5-3-9</b></p><a name=\"hx1i-medicationrequest-status-reason-cs-5-3-9\"> </a><a name=\"hchx1i-medicationrequest-status-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-medicationrequest-status-reason.html\">CodeSystem MedicationRequest Status Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/medicationrequest-status-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:29.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-message-reasons-encounter-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-message-reasons-encounter-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-message-reasons-encounter-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-message-reasons-encounter-cs-5-3-9</b></p><a name=\"hx1i-message-reasons-encounter-cs-5-3-9\"> </a><a name=\"hchx1i-message-reasons-encounter-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-message-reasons-encounter.html\">CodeSystem Example Message Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/message-reasons-encounter"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:29.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-missingtoothreason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-missingtoothreason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-missingtoothreason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-missingtoothreason-cs-5-3-9</b></p><a name=\"hx1i-missingtoothreason-cs-5-3-9\"> </a><a name=\"hchx1i-missingtoothreason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-missingtoothreason.html\">CodeSystem Missing Tooth Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/missingtoothreason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:30.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-modifiers-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-modifiers-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-modifiers-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-modifiers-cs-5-3-9</b></p><a name=\"hx1i-modifiers-cs-5-3-9\"> </a><a name=\"hchx1i-modifiers-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-modifiers.html\">CodeSystem Modifier type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/modifiers"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:31.31-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-name-assembly-order-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-name-assembly-order-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-name-assembly-order-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-name-assembly-order-cs-5-3-9</b></p><a name=\"hx1i-name-assembly-order-cs-5-3-9\"> </a><a name=\"hchx1i-name-assembly-order-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-name-assembly-order.html\">CodeSystem HumanNameAssemblyOrder</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/name-assembly-order"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:31.97-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-need-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-need-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-need-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-need-cs-5-3-9</b></p><a name=\"hx1i-need-cs-5-3-9\"> </a><a name=\"hchx1i-need-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-need.html\">CodeSystem Need</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/need"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:32.61-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-nutrition-intake-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-nutrition-intake-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-nutrition-intake-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-nutrition-intake-category-cs-5-3-9</b></p><a name=\"hx1i-nutrition-intake-category-cs-5-3-9\"> </a><a name=\"hchx1i-nutrition-intake-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-nutrition-intake-category.html\">CodeSystem Nutrition intake category codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/nutrition-intake-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:33.27-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-object-role-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-object-role-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-object-role-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-object-role-cs-5-3-9</b></p><a name=\"hx1i-object-role-cs-5-3-9\"> </a><a name=\"hchx1i-object-role-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-object-role.html\">CodeSystem AuditEventEntityRole</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/object-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:33.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-observation-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-observation-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-observation-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-observation-category-cs-5-3-9</b></p><a name=\"hx1i-observation-category-cs-5-3-9\"> </a><a name=\"hchx1i-observation-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-observation-category.html\">CodeSystem Observation Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/observation-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:34.57-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-observation-statistics-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-observation-statistics-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-observation-statistics-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-observation-statistics-cs-5-3-9</b></p><a name=\"hx1i-observation-statistics-cs-5-3-9\"> </a><a name=\"hchx1i-observation-statistics-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-observation-statistics.html\">CodeSystem StatisticsCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/observation-statistics"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:35.26-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-operation-outcome-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-operation-outcome-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-operation-outcome-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-operation-outcome-cs-5-3-9</b></p><a name=\"hx1i-operation-outcome-cs-5-3-9\"> </a><a name=\"hchx1i-operation-outcome-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-operation-outcome.html\">CodeSystem Operation Outcome Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/operation-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:35.88-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-organization-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-organization-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-organization-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-organization-type-cs-5-3-9</b></p><a name=\"hx1i-organization-type-cs-5-3-9\"> </a><a name=\"hchx1i-organization-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-organization-type.html\">CodeSystem Organization type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/organization-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:36.54-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-parameter-group-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-parameter-group-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-parameter-group-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-parameter-group-cs-5-3-9</b></p><a name=\"hx1i-parameter-group-cs-5-3-9\"> </a><a name=\"hchx1i-parameter-group-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-parameter-group.html\">CodeSystem DeviceDefinitionParameterGroup</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/parameter-group"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:37.21-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-participant-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-participant-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-participant-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-participant-type-cs-5-3-9</b></p><a name=\"hx1i-participant-type-cs-5-3-9\"> </a><a name=\"hchx1i-participant-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-participant-type.html\">CodeSystem Participant type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/participant-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:38.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-payeetype-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-payeetype-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-payeetype-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-payeetype-cs-5-3-9</b></p><a name=\"hx1i-payeetype-cs-5-3-9\"> </a><a name=\"hchx1i-payeetype-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-payeetype.html\">CodeSystem Payee Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payeetype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:38.72-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-payment-adjustment-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-payment-adjustment-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-payment-adjustment-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-payment-adjustment-reason-cs-5-3-9</b></p><a name=\"hx1i-payment-adjustment-reason-cs-5-3-9\"> </a><a name=\"hchx1i-payment-adjustment-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-payment-adjustment-reason.html\">CodeSystem Payment Adjustment Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payment-adjustment-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:39.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-payment-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-payment-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-payment-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-payment-type-cs-5-3-9</b></p><a name=\"hx1i-payment-type-cs-5-3-9\"> </a><a name=\"hchx1i-payment-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-payment-type.html\">CodeSystem Payment Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/payment-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:40.04-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-paymentstatus-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-paymentstatus-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-paymentstatus-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-paymentstatus-cs-5-3-9</b></p><a name=\"hx1i-paymentstatus-cs-5-3-9\"> </a><a name=\"hchx1i-paymentstatus-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-paymentstatus.html\">CodeSystem Payment Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/paymentstatus"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:40.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-plan-definition-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-plan-definition-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-plan-definition-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-plan-definition-type-cs-5-3-9</b></p><a name=\"hx1i-plan-definition-type-cs-5-3-9\"> </a><a name=\"hchx1i-plan-definition-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-plan-definition-type.html\">CodeSystem PlanDefinitionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/plan-definition-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:41.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-practitioner-role-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-practitioner-role-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-practitioner-role-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-practitioner-role-cs-5-3-9</b></p><a name=\"hx1i-practitioner-role-cs-5-3-9\"> </a><a name=\"hchx1i-practitioner-role-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-practitioner-role.html\">CodeSystem Practitioner role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/practitioner-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:41.98-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-primary-source-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-primary-source-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-primary-source-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-primary-source-type-cs-5-3-9</b></p><a name=\"hx1i-primary-source-type-cs-5-3-9\"> </a><a name=\"hchx1i-primary-source-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-primary-source-type.html\">CodeSystem Primary-source-type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/primary-source-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:42.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-processpriority-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-processpriority-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-processpriority-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-processpriority-cs-5-3-9</b></p><a name=\"hx1i-processpriority-cs-5-3-9\"> </a><a name=\"hchx1i-processpriority-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-processpriority.html\">CodeSystem Process Priority Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/processpriority"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:43.26-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-program-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-program-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-program-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-program-cs-5-3-9</b></p><a name=\"hx1i-program-cs-5-3-9\"> </a><a name=\"hchx1i-program-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-program.html\">CodeSystem Program</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/program"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:44.04-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-provenance-participant-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-provenance-participant-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-provenance-participant-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-provenance-participant-type-cs-5-3-9</b></p><a name=\"hx1i-provenance-participant-type-cs-5-3-9\"> </a><a name=\"hchx1i-provenance-participant-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-provenance-participant-type.html\">CodeSystem Provenance participant type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/provenance-participant-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:44.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-push-type-available-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-push-type-available-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-push-type-available-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-push-type-available-cs-5-3-9</b></p><a name=\"hx1i-push-type-available-cs-5-3-9\"> </a><a name=\"hchx1i-push-type-available-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-push-type-available.html\">CodeSystem Push-type-available</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/push-type-available"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:45.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-question-max-occurs-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-question-max-occurs-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-question-max-occurs-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-question-max-occurs-cs-5-3-9</b></p><a name=\"hx1i-question-max-occurs-cs-5-3-9\"> </a><a name=\"hchx1i-question-max-occurs-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-question-max-occurs.html\">CodeSystem MaxOccurs</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/question-max-occurs"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:46.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-questionnaire-usage-mode-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-questionnaire-usage-mode-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-questionnaire-usage-mode-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-questionnaire-usage-mode-cs-5-3-9</b></p><a name=\"hx1i-questionnaire-usage-mode-cs-5-3-9\"> </a><a name=\"hchx1i-questionnaire-usage-mode-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-questionnaire-usage-mode.html\">CodeSystem QuestionnaireItemUsageMode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/questionnaire-usage-mode"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:47.13-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-reaction-event-certainty-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-reaction-event-certainty-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-reaction-event-certainty-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-reaction-event-certainty-cs-5-3-9</b></p><a name=\"hx1i-reaction-event-certainty-cs-5-3-9\"> </a><a name=\"hchx1i-reaction-event-certainty-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-reaction-event-certainty.html\">CodeSystem AllergyIntoleranceCertainty</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/reaction-event-certainty"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:47.84-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-reason-medication-given-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-reason-medication-given-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-reason-medication-given-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-reason-medication-given-cs-5-3-9</b></p><a name=\"hx1i-reason-medication-given-cs-5-3-9\"> </a><a name=\"hchx1i-reason-medication-given-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-reason-medication-given.html\">CodeSystem Reason Medication Given Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/reason-medication-given"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:49.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-recommendation-strength-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-recommendation-strength-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-recommendation-strength-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-recommendation-strength-cs-5-3-9</b></p><a name=\"hx1i-recommendation-strength-cs-5-3-9\"> </a><a name=\"hchx1i-recommendation-strength-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-recommendation-strength.html\">CodeSystem StrengthOfRecommendationRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/recommendation-strength"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:49.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-referencerange-meaning-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-referencerange-meaning-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-referencerange-meaning-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-referencerange-meaning-cs-5-3-9</b></p><a name=\"hx1i-referencerange-meaning-cs-5-3-9\"> </a><a name=\"hchx1i-referencerange-meaning-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-referencerange-meaning.html\">CodeSystem Observation Reference Range Meaning Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/referencerange-meaning"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:50.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-rejection-criteria-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-rejection-criteria-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-rejection-criteria-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-rejection-criteria-cs-5-3-9</b></p><a name=\"hx1i-rejection-criteria-cs-5-3-9\"> </a><a name=\"hchx1i-rejection-criteria-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-rejection-criteria.html\">CodeSystem RejectionCriterion</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/rejection-criteria"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:51.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-research-study-objective-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-research-study-objective-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-research-study-objective-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-research-study-objective-type-cs-5-3-9</b></p><a name=\"hx1i-research-study-objective-type-cs-5-3-9\"> </a><a name=\"hchx1i-research-study-objective-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-objective-type.html\">CodeSystem ResearchStudyObjectiveType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-objective-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:53.00-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-research-study-phase-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-research-study-phase-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-research-study-phase-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-research-study-phase-cs-5-3-9</b></p><a name=\"hx1i-research-study-phase-cs-5-3-9\"> </a><a name=\"hchx1i-research-study-phase-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-phase.html\">CodeSystem ResearchStudyPhase</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:53-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-phase"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:53.67-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-research-study-prim-purp-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-research-study-prim-purp-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-research-study-prim-purp-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-research-study-prim-purp-type-cs-5-3-9</b></p><a name=\"hx1i-research-study-prim-purp-type-cs-5-3-9\"> </a><a name=\"hchx1i-research-study-prim-purp-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-prim-purp-type.html\">CodeSystem ResearchStudyPrimaryPurposeType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:54-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-prim-purp-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:54.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-research-study-reason-stopped-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-research-study-reason-stopped-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-research-study-reason-stopped-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-research-study-reason-stopped-cs-5-3-9</b></p><a name=\"hx1i-research-study-reason-stopped-cs-5-3-9\"> </a><a name=\"hchx1i-research-study-reason-stopped-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-research-study-reason-stopped.html\">CodeSystem ResearchStudyReasonStopped</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-study-reason-stopped"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:55.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-research-subject-milestone-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-research-subject-milestone-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-research-subject-milestone-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-research-subject-milestone-cs-5-3-9</b></p><a name=\"hx1i-research-subject-milestone-cs-5-3-9\"> </a><a name=\"hchx1i-research-subject-milestone-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-research-subject-milestone.html\">CodeSystem ResearchSubjectMilestone</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:55-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-subject-milestone"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:55.99-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-research-subject-state-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-research-subject-state-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-research-subject-state-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-research-subject-state-type-cs-5-3-9</b></p><a name=\"hx1i-research-subject-state-type-cs-5-3-9\"> </a><a name=\"hchx1i-research-subject-state-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-research-subject-state-type.html\">CodeSystem ResearchSubjectStateType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:56-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-subject-state-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:56.68-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-research-subject-state-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-research-subject-state-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-research-subject-state-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-research-subject-state-cs-5-3-9</b></p><a name=\"hx1i-research-subject-state-cs-5-3-9\"> </a><a name=\"hchx1i-research-subject-state-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-research-subject-state.html\">CodeSystem ResearchSubjectState</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:57-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/research-subject-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:57.34-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-resource-security-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-resource-security-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-resource-security-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-resource-security-category-cs-5-3-9</b></p><a name=\"hx1i-resource-security-category-cs-5-3-9\"> </a><a name=\"hchx1i-resource-security-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-resource-security-category.html\">CodeSystem ResourceSecurityCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/resource-security-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:58.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-resource-type-link-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-resource-type-link-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-resource-type-link-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-resource-type-link-cs-5-3-9</b></p><a name=\"hx1i-resource-type-link-cs-5-3-9\"> </a><a name=\"hchx1i-resource-type-link-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-resource-type-link.html\">CodeSystem PayeeResourceType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:58-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/resource-type-link"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:58.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-risk-probability-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-risk-probability-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-risk-probability-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-risk-probability-cs-5-3-9</b></p><a name=\"hx1i-risk-probability-cs-5-3-9\"> </a><a name=\"hchx1i-risk-probability-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-risk-probability.html\">CodeSystem Risk Probability</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:40:59-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/risk-probability"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:40:59.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-security-source-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-security-source-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-security-source-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-security-source-type-cs-5-3-9</b></p><a name=\"hx1i-security-source-type-cs-5-3-9\"> </a><a name=\"hchx1i-security-source-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-security-source-type.html\">CodeSystem Audit Event Source Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/security-source-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:00.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-service-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-service-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-service-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-service-category-cs-5-3-9</b></p><a name=\"hx1i-service-category-cs-5-3-9\"> </a><a name=\"hchx1i-service-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-service-category.html\">CodeSystem Service category</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:00-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:00.69-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-service-provision-conditions-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-service-provision-conditions-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-service-provision-conditions-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-service-provision-conditions-cs-5-3-9</b></p><a name=\"hx1i-service-provision-conditions-cs-5-3-9\"> </a><a name=\"hchx1i-service-provision-conditions-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-service-provision-conditions.html\">CodeSystem ServiceProvisionConditions</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:01-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-provision-conditions"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:01.36-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-service-referral-method-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-service-referral-method-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-service-referral-method-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-service-referral-method-cs-5-3-9</b></p><a name=\"hx1i-service-referral-method-cs-5-3-9\"> </a><a name=\"hchx1i-service-referral-method-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-service-referral-method.html\">CodeSystem ReferralMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-referral-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:02.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-service-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-service-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-service-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-service-type-cs-5-3-9</b></p><a name=\"hx1i-service-type-cs-5-3-9\"> </a><a name=\"hchx1i-service-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-service-type.html\">CodeSystem Service type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:02-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/service-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:02.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-sex-parameter-for-clinical-use-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-sex-parameter-for-clinical-use-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-sex-parameter-for-clinical-use-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-sex-parameter-for-clinical-use-cs-5-3-9</b></p><a name=\"hx1i-sex-parameter-for-clinical-use-cs-5-3-9\"> </a><a name=\"hchx1i-sex-parameter-for-clinical-use-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-sex-parameter-for-clinical-use.html\">CodeSystem Sex Parameter For Clinical Use</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:03-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/sex-parameter-for-clinical-use"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:03.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-smart-capabilities-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-smart-capabilities-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-smart-capabilities-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-smart-capabilities-cs-5-3-9</b></p><a name=\"hx1i-smart-capabilities-cs-5-3-9\"> </a><a name=\"hchx1i-smart-capabilities-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-smart-capabilities.html\">CodeSystem SmartCapabilities</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:04-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/smart-capabilities"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:04.40-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-special-values-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-special-values-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-special-values-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-special-values-cs-5-3-9</b></p><a name=\"hx1i-special-values-cs-5-3-9\"> </a><a name=\"hchx1i-special-values-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-special-values.html\">CodeSystem SpecialValues</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/special-values"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:05.16-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-standards-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-standards-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-standards-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-standards-status-cs-5-3-9</b></p><a name=\"hx1i-standards-status-cs-5-3-9\"> </a><a name=\"hchx1i-standards-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-standards-status.html\">CodeSystem StandardsStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:05-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/standards-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:05.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-state-change-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-state-change-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-state-change-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-state-change-reason-cs-5-3-9</b></p><a name=\"hx1i-state-change-reason-cs-5-3-9\"> </a><a name=\"hchx1i-state-change-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-state-change-reason.html\">CodeSystem StateChangeReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:06-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/state-change-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:06.53-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-statistic-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-statistic-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-statistic-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-statistic-type-cs-5-3-9</b></p><a name=\"hx1i-statistic-type-cs-5-3-9\"> </a><a name=\"hchx1i-statistic-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-statistic-type.html\">CodeSystem StatisticStatisticType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/statistic-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:07.18-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-study-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-study-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-study-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-study-type-cs-5-3-9</b></p><a name=\"hx1i-study-type-cs-5-3-9\"> </a><a name=\"hchx1i-study-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-study-type.html\">CodeSystem StatisticStudyType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:07-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/study-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:07.83-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-subscriber-relationship-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-subscriber-relationship-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-subscriber-relationship-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-subscriber-relationship-cs-5-3-9</b></p><a name=\"hx1i-subscriber-relationship-cs-5-3-9\"> </a><a name=\"hchx1i-subscriber-relationship-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-subscriber-relationship.html\">CodeSystem SubscriberPolicyholder Relationship Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:08-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscriber-relationship"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:08.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-subscription-channel-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-subscription-channel-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-subscription-channel-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-subscription-channel-type-cs-5-3-9</b></p><a name=\"hx1i-subscription-channel-type-cs-5-3-9\"> </a><a name=\"hchx1i-subscription-channel-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-channel-type.html\">CodeSystem SubscriptionChannel Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-channel-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:09.11-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-subscription-error-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-subscription-error-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-subscription-error-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-subscription-error-cs-5-3-9</b></p><a name=\"hx1i-subscription-error-cs-5-3-9\"> </a><a name=\"hchx1i-subscription-error-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-error.html\">CodeSystem Subscription Error Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:09-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-error"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:09.86-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-subscription-status-at-event-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-subscription-status-at-event-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-subscription-status-at-event-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-subscription-status-at-event-cs-5-3-9</b></p><a name=\"hx1i-subscription-status-at-event-cs-5-3-9\"> </a><a name=\"hchx1i-subscription-status-at-event-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-status-at-event.html\">CodeSystem SubscriptionStatusAtEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:10-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-status-at-event"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:10.56-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-subscription-tag-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-subscription-tag-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-subscription-tag-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-subscription-tag-cs-5-3-9</b></p><a name=\"hx1i-subscription-tag-cs-5-3-9\"> </a><a name=\"hchx1i-subscription-tag-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-subscription-tag.html\">CodeSystem SubscriptionTag</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/subscription-tag"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:11.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-substance-category-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-substance-category-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-substance-category-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-substance-category-cs-5-3-9</b></p><a name=\"hx1i-substance-category-cs-5-3-9\"> </a><a name=\"hchx1i-substance-category-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-substance-category.html\">CodeSystem Substance Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:11-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/substance-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:11.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-supply-item-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-supply-item-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-supply-item-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-supply-item-type-cs-5-3-9</b></p><a name=\"hx1i-supply-item-type-cs-5-3-9\"> </a><a name=\"hchx1i-supply-item-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-supply-item-type.html\">CodeSystem Supply Item Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:12-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/supply-item-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:12.60-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-supply-kind-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-supply-kind-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-supply-kind-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-supply-kind-cs-5-3-9</b></p><a name=\"hx1i-supply-kind-cs-5-3-9\"> </a><a name=\"hchx1i-supply-kind-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-supply-kind.html\">CodeSystem Supply Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:13-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/supply-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:13.28-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-supplyrequest-reason-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-supplyrequest-reason-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-supplyrequest-reason-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-supplyrequest-reason-cs-5-3-9</b></p><a name=\"hx1i-supplyrequest-reason-cs-5-3-9\"> </a><a name=\"hchx1i-supplyrequest-reason-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-supplyrequest-reason.html\">CodeSystem SupplyRequestReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/supplyrequest-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:14.10-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-synthesis-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-synthesis-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-synthesis-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-synthesis-type-cs-5-3-9</b></p><a name=\"hx1i-synthesis-type-cs-5-3-9\"> </a><a name=\"hchx1i-synthesis-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-synthesis-type.html\">CodeSystem StatisticSynthesisType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:14-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/synthesis-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:14.90-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-testscript-operation-codes-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-testscript-operation-codes-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-testscript-operation-codes-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-testscript-operation-codes-cs-5-3-9</b></p><a name=\"hx1i-testscript-operation-codes-cs-5-3-9\"> </a><a name=\"hchx1i-testscript-operation-codes-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-testscript-operation-codes.html\">CodeSystem Test script operation code</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:15-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/testscript-operation-codes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:15.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-testscript-profile-destination-types-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-testscript-profile-destination-types-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-testscript-profile-destination-types-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-testscript-profile-destination-types-cs-5-3-9</b></p><a name=\"hx1i-testscript-profile-destination-types-cs-5-3-9\"> </a><a name=\"hchx1i-testscript-profile-destination-types-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-testscript-profile-destination-types.html\">CodeSystem Test script profile destination type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:16-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/testscript-profile-destination-types"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:16.28-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-testscript-profile-origin-types-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-testscript-profile-origin-types-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-testscript-profile-origin-types-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-testscript-profile-origin-types-cs-5-3-9</b></p><a name=\"hx1i-testscript-profile-origin-types-cs-5-3-9\"> </a><a name=\"hchx1i-testscript-profile-origin-types-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-testscript-profile-origin-types.html\">CodeSystem Test script profile origin type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/testscript-profile-origin-types"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:17.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-usage-context-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-usage-context-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-usage-context-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-usage-context-type-cs-5-3-9</b></p><a name=\"hx1i-usage-context-type-cs-5-3-9\"> </a><a name=\"hchx1i-usage-context-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-usage-context-type.html\">CodeSystem UsageContextType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:17-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/usage-context-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:17.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-validation-process-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-validation-process-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-validation-process-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-validation-process-cs-5-3-9</b></p><a name=\"hx1i-validation-process-cs-5-3-9\"> </a><a name=\"hchx1i-validation-process-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-validation-process.html\">CodeSystem Validation-process</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:18-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/validation-process"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:18.51-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-validation-status-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-validation-status-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-validation-status-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-validation-status-cs-5-3-9</b></p><a name=\"hx1i-validation-status-cs-5-3-9\"> </a><a name=\"hchx1i-validation-status-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-validation-status.html\">CodeSystem Validation-status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/validation-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:19.18-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-validation-type-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-validation-type-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-validation-type-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-validation-type-cs-5-3-9</b></p><a name=\"hx1i-validation-type-cs-5-3-9\"> </a><a name=\"hchx1i-validation-type-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-validation-type.html\">CodeSystem Validation-type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:19-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/validation-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:19.80-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-variable-role-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-variable-role-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-variable-role-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-variable-role-cs-5-3-9</b></p><a name=\"hx1i-variable-role-cs-5-3-9\"> </a><a name=\"hchx1i-variable-role-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-variable-role.html\">CodeSystem EvidenceVariableRole</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:20-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/variable-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:20.59-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-variant-state-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-variant-state-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-variant-state-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-variant-state-cs-5-3-9</b></p><a name=\"hx1i-variant-state-cs-5-3-9\"> </a><a name=\"hchx1i-variant-state-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-variant-state.html\">CodeSystem sequenceStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/variant-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:21.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-verificationresult-communication-method-cs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-verificationresult-communication-method-cs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-verificationresult-communication-method-cs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-verificationresult-communication-method-cs-5-3-9</b></p><a name=\"hx1i-verificationresult-communication-method-cs-5-3-9\"> </a><a name=\"hchx1i-verificationresult-communication-method-cs-5-3-9\"> </a><p>Provenance for <a href=\"CodeSystem-verificationresult-communication-method.html\">CodeSystem VerificationResult Communication Method</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:21-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "CodeSystem/verificationresult-communication-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:21.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-action-participant-role-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-action-participant-role-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-action-participant-role-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-action-participant-role-vs-5-3-9</b></p><a name=\"hx1i-action-participant-role-vs-5-3-9\"> </a><a name=\"hchx1i-action-participant-role-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-action-participant-role.html\">ValueSet Action Participant Role</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:22-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/action-participant-role"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:22.55-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-action-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-action-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-action-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-action-type-vs-5-3-9</b></p><a name=\"hx1i-action-type-vs-5-3-9\"> </a><a name=\"hchx1i-action-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-action-type.html\">ValueSet ActionType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/action-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:23.29-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-activity-definition-category-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-activity-definition-category-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-activity-definition-category-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-activity-definition-category-vs-5-3-9</b></p><a name=\"hx1i-activity-definition-category-vs-5-3-9\"> </a><a name=\"hchx1i-activity-definition-category-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-activity-definition-category.html\">ValueSet ActivityDefinitionCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:23-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/activity-definition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:23.95-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adjudication-error-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adjudication-error-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adjudication-error-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adjudication-error-vs-5-3-9</b></p><a name=\"hx1i-adjudication-error-vs-5-3-9\"> </a><a name=\"hchx1i-adjudication-error-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adjudication-error.html\">ValueSet AdjudicationError</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:24-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adjudication-error"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:24.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adjudication-reason-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adjudication-reason-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adjudication-reason-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adjudication-reason-vs-5-3-9</b></p><a name=\"hx1i-adjudication-reason-vs-5-3-9\"> </a><a name=\"hchx1i-adjudication-reason-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adjudication-reason.html\">ValueSet Adjudication Reason Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:25-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adjudication-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:25.37-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adjudication-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adjudication-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adjudication-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adjudication-vs-5-3-9</b></p><a name=\"hx1i-adjudication-vs-5-3-9\"> </a><a name=\"hchx1i-adjudication-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adjudication.html\">ValueSet Adjudication Value Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adjudication"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:26.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-category-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-category-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-category-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-category-vs-5-3-9</b></p><a name=\"hx1i-adverse-event-category-vs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-category-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-category.html\">ValueSet AdverseEventCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:26-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:26.63-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-causality-assess-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-causality-assess-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-causality-assess-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-causality-assess-vs-5-3-9</b></p><a name=\"hx1i-adverse-event-causality-assess-vs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-causality-assess-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-causality-assess.html\">ValueSet AdverseEventCausalityAssessment</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:27-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-causality-assess"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:27.40-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-causality-method-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-causality-method-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-causality-method-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-causality-method-vs-5-3-9</b></p><a name=\"hx1i-adverse-event-causality-method-vs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-causality-method-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-causality-method.html\">ValueSet AdverseEventCausalityMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-causality-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:28.03-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-seriousness-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-seriousness-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-seriousness-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-seriousness-vs-5-3-9</b></p><a name=\"hx1i-adverse-event-seriousness-vs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-seriousness-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-seriousness.html\">ValueSet AdverseEventSeriousness</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-seriousness"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:28.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-adverse-event-severity-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-adverse-event-severity-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-adverse-event-severity-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-adverse-event-severity-vs-5-3-9</b></p><a name=\"hx1i-adverse-event-severity-vs-5-3-9\"> </a><a name=\"hchx1i-adverse-event-severity-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-adverse-event-severity.html\">ValueSet AdverseEventSeverity</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:28-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/adverse-event-severity"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:28.84-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-allerg-intol-substance-exp-risk-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-allerg-intol-substance-exp-risk-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-allerg-intol-substance-exp-risk-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-allerg-intol-substance-exp-risk-vs-5-3-9</b></p><a name=\"hx1i-allerg-intol-substance-exp-risk-vs-5-3-9\"> </a><a name=\"hchx1i-allerg-intol-substance-exp-risk-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-allerg-intol-substance-exp-risk.html\">ValueSet AllergyIntoleranceSubstanceExposureRisk</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/allerg-intol-substance-exp-risk"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:29.24-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-allergyintolerance-clinical-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-allergyintolerance-clinical-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-allergyintolerance-clinical-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-allergyintolerance-clinical-vs-5-3-9</b></p><a name=\"hx1i-allergyintolerance-clinical-vs-5-3-9\"> </a><a name=\"hchx1i-allergyintolerance-clinical-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-allergyintolerance-clinical.html\">ValueSet AllergyIntolerance Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:29-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/allergyintolerance-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:29.67-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-allergyintolerance-verification-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-allergyintolerance-verification-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-allergyintolerance-verification-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-allergyintolerance-verification-vs-5-3-9</b></p><a name=\"hx1i-allergyintolerance-verification-vs-5-3-9\"> </a><a name=\"hchx1i-allergyintolerance-verification-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-allergyintolerance-verification.html\">ValueSet AllergyIntolerance Verification Status</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/allergyintolerance-verification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:30.07-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-appointment-cancellation-reason-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-appointment-cancellation-reason-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-appointment-cancellation-reason-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-appointment-cancellation-reason-vs-5-3-9</b></p><a name=\"hx1i-appointment-cancellation-reason-vs-5-3-9\"> </a><a name=\"hchx1i-appointment-cancellation-reason-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-appointment-cancellation-reason.html\">ValueSet Appointment cancellation reason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/appointment-cancellation-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:30.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-attribute-estimate-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-attribute-estimate-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-attribute-estimate-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-attribute-estimate-type-vs-5-3-9</b></p><a name=\"hx1i-attribute-estimate-type-vs-5-3-9\"> </a><a name=\"hchx1i-attribute-estimate-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-attribute-estimate-type.html\">ValueSet StatisticAttributeEstimateType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:30-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/attribute-estimate-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:30.88-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-audit-event-outcome-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-audit-event-outcome-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-audit-event-outcome-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-audit-event-outcome-vs-5-3-9</b></p><a name=\"hx1i-audit-event-outcome-vs-5-3-9\"> </a><a name=\"hchx1i-audit-event-outcome-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-audit-event-outcome.html\">ValueSet Audit Event Outcome</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/audit-event-outcome"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:31.28-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-audit-source-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-audit-source-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-audit-source-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-audit-source-type-vs-5-3-9</b></p><a name=\"hx1i-audit-source-type-vs-5-3-9\"> </a><a name=\"hchx1i-audit-source-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-audit-source-type.html\">ValueSet Audit Event Source Type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:31-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/audit-source-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:31.68-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-basic-resource-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-basic-resource-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-basic-resource-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-basic-resource-type-vs-5-3-9</b></p><a name=\"hx1i-basic-resource-type-vs-5-3-9\"> </a><a name=\"hchx1i-basic-resource-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-basic-resource-type.html\">ValueSet Basic Resource Types</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/basic-resource-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:32.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-network-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-network-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-network-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-network-vs-5-3-9</b></p><a name=\"hx1i-benefit-network-vs-5-3-9\"> </a><a name=\"hchx1i-benefit-network-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-benefit-network.html\">ValueSet Network Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-network"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:32.50-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-term-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-term-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-term-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-term-vs-5-3-9</b></p><a name=\"hx1i-benefit-term-vs-5-3-9\"> </a><a name=\"hchx1i-benefit-term-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-benefit-term.html\">ValueSet Benefit Term Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:32-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-term"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:32.90-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-type-vs-5-3-9</b></p><a name=\"hx1i-benefit-type-vs-5-3-9\"> </a><a name=\"hchx1i-benefit-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-benefit-type.html\">ValueSet Benefit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:33.30-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-benefit-unit-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-benefit-unit-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-benefit-unit-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-benefit-unit-vs-5-3-9</b></p><a name=\"hx1i-benefit-unit-vs-5-3-9\"> </a><a name=\"hchx1i-benefit-unit-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-benefit-unit.html\">ValueSet Unit Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:33-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/benefit-unit"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:33.71-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-catalogType-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-catalogType-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-catalogType-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-catalogType-vs-5-3-9</b></p><a name=\"hx1i-catalogType-vs-5-3-9\"> </a><a name=\"hchx1i-catalogType-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-catalogType.html\">ValueSet CatalogType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/catalogType"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:34.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-certainty-rating-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-certainty-rating-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-certainty-rating-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-certainty-rating-vs-5-3-9</b></p><a name=\"hx1i-certainty-rating-vs-5-3-9\"> </a><a name=\"hchx1i-certainty-rating-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-certainty-rating.html\">ValueSet StatisticCertaintyRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/certainty-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:34.52-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-certainty-subcomponent-rating-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-certainty-subcomponent-rating-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-certainty-subcomponent-rating-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-certainty-subcomponent-rating-vs-5-3-9</b></p><a name=\"hx1i-certainty-subcomponent-rating-vs-5-3-9\"> </a><a name=\"hchx1i-certainty-subcomponent-rating-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-certainty-subcomponent-rating.html\">ValueSet StatisticCertaintySubcomponentRating</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:34-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/certainty-subcomponent-rating"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:34.93-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-certainty-subcomponent-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-certainty-subcomponent-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-certainty-subcomponent-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-certainty-subcomponent-type-vs-5-3-9</b></p><a name=\"hx1i-certainty-subcomponent-type-vs-5-3-9\"> </a><a name=\"hchx1i-certainty-subcomponent-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-certainty-subcomponent-type.html\">ValueSet StatisticCertaintySubcomponentType</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/certainty-subcomponent-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:35.33-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-characteristic-method-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-characteristic-method-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-characteristic-method-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-characteristic-method-vs-5-3-9</b></p><a name=\"hx1i-characteristic-method-vs-5-3-9\"> </a><a name=\"hchx1i-characteristic-method-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-characteristic-method.html\">ValueSet CharacteristicMethod</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:35-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/characteristic-method"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:35.73-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-chargeitem-billingcodes-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-chargeitem-billingcodes-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-chargeitem-billingcodes-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-chargeitem-billingcodes-vs-5-3-9</b></p><a name=\"hx1i-chargeitem-billingcodes-vs-5-3-9\"> </a><a name=\"hchx1i-chargeitem-billingcodes-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-chargeitem-billingcodes.html\">ValueSet ChargeItemCode</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/chargeitem-billingcodes"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:36.14-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-choice-list-orientation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-choice-list-orientation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-choice-list-orientation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-choice-list-orientation-vs-5-3-9</b></p><a name=\"hx1i-choice-list-orientation-vs-5-3-9\"> </a><a name=\"hchx1i-choice-list-orientation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-choice-list-orientation.html\">ValueSet ChoiceListOrientation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/choice-list-orientation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:36.55-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-chromosome-human-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-chromosome-human-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-chromosome-human-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-chromosome-human-vs-5-3-9</b></p><a name=\"hx1i-chromosome-human-vs-5-3-9\"> </a><a name=\"hchx1i-chromosome-human-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-chromosome-human.html\">ValueSet chromosome-human</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:36-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/chromosome-human"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:36.96-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-careteamrole-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-careteamrole-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-careteamrole-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-careteamrole-vs-5-3-9</b></p><a name=\"hx1i-claim-careteamrole-vs-5-3-9\"> </a><a name=\"hchx1i-claim-careteamrole-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-claim-careteamrole.html\">ValueSet Claim Care Team Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-careteamrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:37.35-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-exception-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-exception-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-exception-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-exception-vs-5-3-9</b></p><a name=\"hx1i-claim-exception-vs-5-3-9\"> </a><a name=\"hchx1i-claim-exception-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-claim-exception.html\">ValueSet Exception Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:37-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-exception"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:37.76-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-informationcategory-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-informationcategory-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-informationcategory-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-informationcategory-vs-5-3-9</b></p><a name=\"hx1i-claim-informationcategory-vs-5-3-9\"> </a><a name=\"hchx1i-claim-informationcategory-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-claim-informationcategory.html\">ValueSet Claim Information Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-informationcategory"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:38.17-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-modifiers-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-modifiers-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-modifiers-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-modifiers-vs-5-3-9</b></p><a name=\"hx1i-claim-modifiers-vs-5-3-9\"> </a><a name=\"hchx1i-claim-modifiers-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-claim-modifiers.html\">ValueSet Modifier type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-modifiers"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:38.58-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-subtype-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-subtype-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-subtype-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-subtype-vs-5-3-9</b></p><a name=\"hx1i-claim-subtype-vs-5-3-9\"> </a><a name=\"hchx1i-claim-subtype-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-claim-subtype.html\">ValueSet Example Claim SubType Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:38-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:38.99-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-claim-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-claim-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-claim-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-claim-type-vs-5-3-9</b></p><a name=\"hx1i-claim-type-vs-5-3-9\"> </a><a name=\"hchx1i-claim-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-claim-type.html\">ValueSet Claim Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/claim-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:39.39-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-clinical-discharge-disposition-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-clinical-discharge-disposition-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-clinical-discharge-disposition-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-clinical-discharge-disposition-vs-5-3-9</b></p><a name=\"hx1i-clinical-discharge-disposition-vs-5-3-9\"> </a><a name=\"hchx1i-clinical-discharge-disposition-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-clinical-discharge-disposition.html\">ValueSet Clinical Discharge Disposition</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:39-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/clinical-discharge-disposition"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:39.79-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-codesystem-altcode-kind-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-codesystem-altcode-kind-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-codesystem-altcode-kind-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-codesystem-altcode-kind-vs-5-3-9</b></p><a name=\"hx1i-codesystem-altcode-kind-vs-5-3-9\"> </a><a name=\"hchx1i-codesystem-altcode-kind-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-codesystem-altcode-kind.html\">ValueSet AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/codesystem-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:40.20-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-common-tags-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-common-tags-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-common-tags-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-common-tags-vs-5-3-9</b></p><a name=\"hx1i-common-tags-vs-5-3-9\"> </a><a name=\"hchx1i-common-tags-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-common-tags.html\">ValueSet Common Tags</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:40-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/common-tags"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:40.61-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-communication-category-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-communication-category-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-communication-category-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-communication-category-vs-5-3-9</b></p><a name=\"hx1i-communication-category-vs-5-3-9\"> </a><a name=\"hchx1i-communication-category-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-communication-category.html\">ValueSet CommunicationCategory</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/communication-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:41.01-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-communication-not-done-reason-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-communication-not-done-reason-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-communication-not-done-reason-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-communication-not-done-reason-vs-5-3-9</b></p><a name=\"hx1i-communication-not-done-reason-vs-5-3-9\"> </a><a name=\"hchx1i-communication-not-done-reason-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-communication-not-done-reason.html\">ValueSet CommunicationNotDoneReason</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/communication-not-done-reason"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:41.41-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-communication-topic-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-communication-topic-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-communication-topic-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-communication-topic-vs-5-3-9</b></p><a name=\"hx1i-communication-topic-vs-5-3-9\"> </a><a name=\"hchx1i-communication-topic-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-communication-topic.html\">ValueSet CommunicationTopic</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:41-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/communication-topic"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:41.82-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-composite-measure-scoring-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-composite-measure-scoring-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-composite-measure-scoring-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-composite-measure-scoring-vs-5-3-9</b></p><a name=\"hx1i-composite-measure-scoring-vs-5-3-9\"> </a><a name=\"hchx1i-composite-measure-scoring-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-composite-measure-scoring.html\">ValueSet CompositeMeasureScoring</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/composite-measure-scoring"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:42.23-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-composition-altcode-kind-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-composition-altcode-kind-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-composition-altcode-kind-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-composition-altcode-kind-vs-5-3-9</b></p><a name=\"hx1i-composition-altcode-kind-vs-5-3-9\"> </a><a name=\"hchx1i-composition-altcode-kind-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-composition-altcode-kind.html\">ValueSet AlternativeCodeKind</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:42-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/composition-altcode-kind"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:42.64-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-category-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-category-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-category-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-category-vs-5-3-9</b></p><a name=\"hx1i-condition-category-vs-5-3-9\"> </a><a name=\"hchx1i-condition-category-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-condition-category.html\">ValueSet Condition Category Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-category"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:43.05-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-clinical-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-clinical-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-clinical-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-clinical-vs-5-3-9</b></p><a name=\"hx1i-condition-clinical-vs-5-3-9\"> </a><a name=\"hchx1i-condition-clinical-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-condition-clinical.html\">ValueSet Condition Clinical Status Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-clinical"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:43.44-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-state-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-state-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-state-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-state-vs-5-3-9</b></p><a name=\"hx1i-condition-state-vs-5-3-9\"> </a><a name=\"hchx1i-condition-state-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-condition-state.html\">ValueSet ConditionState</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:43-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-state"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:43.85-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-condition-ver-status-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-condition-ver-status-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-condition-ver-status-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-condition-ver-status-vs-5-3-9</b></p><a name=\"hx1i-condition-ver-status-vs-5-3-9\"> </a><a name=\"hchx1i-condition-ver-status-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-condition-ver-status.html\">ValueSet ConditionVerificationStatus</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/condition-ver-status"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:44.25-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-conformance-expectation-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-conformance-expectation-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-conformance-expectation-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-conformance-expectation-vs-5-3-9</b></p><a name=\"hx1i-conformance-expectation-vs-5-3-9\"> </a><a name=\"hchx1i-conformance-expectation-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-conformance-expectation.html\">ValueSet ConformanceExpectation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:44-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/conformance-expectation"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:44.66-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consent-action-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consent-action-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consent-action-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consent-action-vs-5-3-9</b></p><a name=\"hx1i-consent-action-vs-5-3-9\"> </a><a name=\"hchx1i-consent-action-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-consent-action.html\">ValueSet Consent Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-action"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:45.06-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consent-policy-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consent-policy-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consent-policy-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consent-policy-vs-5-3-9</b></p><a name=\"hx1i-consent-policy-vs-5-3-9\"> </a><a name=\"hchx1i-consent-policy-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-consent-policy.html\">ValueSet Consent PolicyRule Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-policy"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:45.45-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consent-scope-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consent-scope-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consent-scope-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consent-scope-vs-5-3-9</b></p><a name=\"hx1i-consent-scope-vs-5-3-9\"> </a><a name=\"hchx1i-consent-scope-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-consent-scope.html\">ValueSet Consent Scope Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:45-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-scope"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:45.86-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-consent-verification-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-consent-verification-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-consent-verification-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-consent-verification-vs-5-3-9</b></p><a name=\"hx1i-consent-verification-vs-5-3-9\"> </a><a name=\"hchx1i-consent-verification-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-consent-verification.html\">ValueSet Consent Verification Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/consent-verification"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:46.27-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contactentity-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contactentity-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contactentity-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contactentity-type-vs-5-3-9</b></p><a name=\"hx1i-contactentity-type-vs-5-3-9\"> </a><a name=\"hchx1i-contactentity-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contactentity-type.html\">ValueSet Contact entity type</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:46-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contactentity-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:46.68-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-container-cap-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-container-cap-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-container-cap-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-container-cap-vs-5-3-9</b></p><a name=\"hx1i-container-cap-vs-5-3-9\"> </a><a name=\"hchx1i-container-cap-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-container-cap.html\">ValueSet ContainerCap</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/container-cap"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:47.09-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-action-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-action-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-action-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-action-vs-5-3-9</b></p><a name=\"hx1i-contract-action-vs-5-3-9\"> </a><a name=\"hchx1i-contract-action-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-action.html\">ValueSet Contract Action Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-action"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:47.48-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-actorrole-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-actorrole-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-actorrole-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-actorrole-vs-5-3-9</b></p><a name=\"hx1i-contract-actorrole-vs-5-3-9\"> </a><a name=\"hchx1i-contract-actorrole-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-actorrole.html\">ValueSet Contract Actor Role Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:47-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-actorrole"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:47.89-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-content-derivative-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-content-derivative-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-content-derivative-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-content-derivative-vs-5-3-9</b></p><a name=\"hx1i-contract-content-derivative-vs-5-3-9\"> </a><a name=\"hchx1i-contract-content-derivative-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-content-derivative.html\">ValueSet Contract Content Derivation Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-content-derivative"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:48.30-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-data-meaning-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-data-meaning-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-data-meaning-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-data-meaning-vs-5-3-9</b></p><a name=\"hx1i-contract-data-meaning-vs-5-3-9\"> </a><a name=\"hchx1i-contract-data-meaning-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-data-meaning.html\">ValueSet ContractDataMeaning</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:48-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-data-meaning"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:48.72-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-signer-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-signer-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-signer-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-signer-type-vs-5-3-9</b></p><a name=\"hx1i-contract-signer-type-vs-5-3-9\"> </a><a name=\"hchx1i-contract-signer-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-signer-type.html\">ValueSet Contract Signer Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-signer-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:49.12-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-subtype-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-subtype-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-subtype-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-subtype-vs-5-3-9</b></p><a name=\"hx1i-contract-subtype-vs-5-3-9\"> </a><a name=\"hchx1i-contract-subtype-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-subtype.html\">ValueSet Contract Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:49.52-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-term-subtype-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-term-subtype-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-term-subtype-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-term-subtype-vs-5-3-9</b></p><a name=\"hx1i-contract-term-subtype-vs-5-3-9\"> </a><a name=\"hchx1i-contract-term-subtype-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-term-subtype.html\">ValueSet Contract Term Subtype Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:49-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-term-subtype"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:49.92-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-term-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-term-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-term-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-term-type-vs-5-3-9</b></p><a name=\"hx1i-contract-term-type-vs-5-3-9\"> </a><a name=\"hchx1i-contract-term-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-term-type.html\">ValueSet Contract Term Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-term-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:50.32-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-contract-type-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-contract-type-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-contract-type-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-contract-type-vs-5-3-9</b></p><a name=\"hx1i-contract-type-vs-5-3-9\"> </a><a name=\"hchx1i-contract-type-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-contract-type.html\">ValueSet Contract Type Codes</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:50-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td>Marc Duteau</td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type custodian}\">Custodian</span></td><td>TSMG</td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "ValueSet/contract-type"
          }
        ],
        "occurredPeriod" : {
          "end" : "2023-11-14"
        },
        "recorded" : "2023-11-14T12:41:50.73-07:00",
        "authorization" : [
          {
            "concept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "METAMGT"
                }
              ],
              "text" : "Add standard copyright and contact to internal content; up-476"
            }
          }
        ],
        "activity" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
              "code" : "UPDATE"
            }
          ]
        },
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author"
                }
              ]
            },
            "who" : {
              "display" : "Marc Duteau"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "custodian"
                }
              ]
            },
            "who" : {
              "display" : "TSMG"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://terminology.hl7.org/fhir/Provenance/hx1i-copy-number-event-vs-5-3-9",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "hx1i-copy-number-event-vs-5-3-9",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_hx1i-copy-number-event-vs-5-3-9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance hx1i-copy-number-event-vs-5-3-9</b></p><a name=\"hx1i-copy-number-event-vs-5-3-9\"> </a><a name=\"hchx1i-copy-number-event-vs-5-3-9\"> </a><p>Provenance for <a href=\"ValueSet-copy-number-event.html\">ValueSet CopyNumberEvent</a></p><p>Summary</p><table class=\"grid\"><tr><td>Occurrence</td><td>?? --&gt; 2023-11-14</td></tr><tr><td>Recorded</td><td>2023-11-14 12:41:51-0700</td></tr><tr><td>Activity</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-DataOperation UPDATE}\">revise</span></td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span>